/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils;

import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.util.HelpFormatter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterator;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.map.OpenObjectIntHashMap;

public final class SequenceFileDumper
extends AbstractJob {
    public SequenceFileDumper() {
        this.setConf(new Configuration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        Writer writer;
        boolean shouldClose;
        this.addOption("seqFile", "s", "The Sequence File to read in", true);
        this.addOption((Option)DefaultOptionCreator.outputOption().create());
        this.addOption("substring", "b", "The number of chars to print out per value", false);
        this.addOption(SequenceFileDumper.buildOption((String)"count", (String)"c", (String)"Report the count only", (boolean)false, (boolean)false, null));
        this.addOption("numItems", "n", "Output at most <n> key value pairs", false);
        this.addOption(SequenceFileDumper.buildOption((String)"facets", (String)"fa", (String)"Output the counts per key.  Note, if there are a lot of unique keys, this can take up a fair amount of memory", (boolean)false, (boolean)false, null));
        if (this.parseArguments(args) == null) {
            return -1;
        }
        Path path = new Path(this.getOption("seqFile"));
        Configuration conf = new Configuration();
        if (this.hasOption("output")) {
            shouldClose = true;
            writer = Files.newWriter((File)new File(this.getOption("output")), (Charset)Charsets.UTF_8);
        } else {
            shouldClose = false;
            writer = new OutputStreamWriter(System.out);
        }
        try {
            writer.append("Input Path: ").append(String.valueOf(path)).append('\n');
            int sub = Integer.MAX_VALUE;
            if (this.hasOption("substring")) {
                sub = Integer.parseInt(this.getOption("substring"));
            }
            boolean countOnly = this.hasOption("count");
            SequenceFileIterator iterator = new SequenceFileIterator(path, true, conf);
            writer.append("Key class: ").append(iterator.getKeyClass().toString());
            writer.append(" Value Class: ").append(iterator.getValueClass().toString()).append('\n');
            OpenObjectIntHashMap facets = null;
            if (this.hasOption("facets")) {
                facets = new OpenObjectIntHashMap();
            }
            long count = 0L;
            if (countOnly) {
                while (iterator.hasNext()) {
                    Pair record = (Pair)iterator.next();
                    String key = record.getFirst().toString();
                    if (facets != null) {
                        facets.adjustOrPutValue((Object)key, 1, 1);
                    }
                    ++count;
                }
                writer.append("Count: ").append(String.valueOf(count)).append('\n');
            } else {
                long numItems = Long.MAX_VALUE;
                if (this.hasOption("numItems")) {
                    numItems = Long.parseLong(this.getOption("numItems"));
                    writer.append("Max Items to dump: ").append(String.valueOf(numItems)).append("\n");
                }
                while (iterator.hasNext() && count < numItems) {
                    Pair record = (Pair)iterator.next();
                    String key = record.getFirst().toString();
                    writer.append("Key: ").append(key);
                    String str = record.getSecond().toString();
                    writer.append(": Value: ").append(str.length() > sub ? str.substring(0, sub) : str);
                    writer.write(10);
                    if (facets != null) {
                        facets.adjustOrPutValue((Object)key, 1, 1);
                    }
                    ++count;
                }
                writer.append("Count: ").append(String.valueOf(count)).append('\n');
            }
            if (facets != null) {
                ArrayList keyList = new ArrayList(facets.size());
                IntArrayList valueList = new IntArrayList(facets.size());
                facets.pairsSortedByKey(keyList, valueList);
                writer.append("-----Facets---\n");
                writer.append("Key\t\tCount\n");
                int i = 0;
                for (String key : keyList) {
                    writer.append(key).append("\t\t").append(String.valueOf(valueList.get(i++))).append('\n');
                }
            }
            writer.flush();
        }
        finally {
            if (shouldClose) {
                Closeables.closeQuietly((Closeable)writer);
            }
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        new SequenceFileDumper().run(args);
    }

    private static void printHelp(Group group) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setGroup(group);
        formatter.print();
    }
}

