/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import javax.crypto.Cipher;
import org.apache.nifi.properties.AESSensitivePropertyProviderFactory;
import org.apache.nifi.properties.ProtectedNiFiProperties;
import org.apache.nifi.properties.SensitivePropertyProvider;
import org.apache.nifi.properties.SensitivePropertyProviderFactory;
import org.apache.nifi.security.kms.CryptoUtils;
import org.apache.nifi.util.NiFiProperties;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NiFiPropertiesLoader {
    private static final Logger logger = LoggerFactory.getLogger(NiFiPropertiesLoader.class);
    private NiFiProperties instance;
    private String keyHex;
    private static SensitivePropertyProviderFactory sensitivePropertyProviderFactory;

    public static NiFiPropertiesLoader withKey(String keyHex) {
        NiFiPropertiesLoader loader = new NiFiPropertiesLoader();
        loader.setKeyHex(keyHex);
        return loader;
    }

    public void setKeyHex(String keyHex) {
        if (this.keyHex != null && !this.keyHex.trim().isEmpty()) {
            throw new RuntimeException("Cannot overwrite an existing key");
        }
        this.keyHex = keyHex;
    }

    public static NiFiProperties loadDefaultWithKeyFromBootstrap() throws IOException {
        try {
            return new NiFiPropertiesLoader().loadDefault();
        }
        catch (Exception e) {
            logger.warn("Encountered an error naively loading the nifi.properties file because one or more properties are protected: {}", (Object)e.getLocalizedMessage());
            try {
                String keyHex = CryptoUtils.extractKeyFromBootstrapFile();
                return NiFiPropertiesLoader.withKey(keyHex).loadDefault();
            }
            catch (IOException e2) {
                logger.error("Encountered an exception loading the default nifi.properties file {} with the key provided in bootstrap.conf", (Object)CryptoUtils.getDefaultFilePath(), (Object)e2);
                throw e2;
            }
        }
    }

    @Deprecated
    public static String extractKeyFromBootstrapFile() throws IOException {
        return NiFiPropertiesLoader.extractKeyFromBootstrapFile("");
    }

    @Deprecated
    public static String extractKeyFromBootstrapFile(String bootstrapPath) throws IOException {
        return CryptoUtils.extractKeyFromBootstrapFile((String)bootstrapPath);
    }

    private NiFiProperties loadDefault() {
        return this.load(CryptoUtils.getDefaultFilePath());
    }

    static String getDefaultProviderKey() {
        try {
            return "aes/gcm/" + (Cipher.getMaxAllowedKeyLength("AES") > 128 ? "256" : "128");
        }
        catch (NoSuchAlgorithmException e) {
            return "aes/gcm/128";
        }
    }

    private void initializeSensitivePropertyProviderFactory() {
        sensitivePropertyProviderFactory = new AESSensitivePropertyProviderFactory(this.keyHex);
    }

    private SensitivePropertyProvider getSensitivePropertyProvider() {
        this.initializeSensitivePropertyProviderFactory();
        return sensitivePropertyProviderFactory.getProvider();
    }

    ProtectedNiFiProperties readProtectedPropertiesFromDisk(File file) {
        if (file == null || !file.exists() || !file.canRead()) {
            String path = file == null ? "missing file" : file.getAbsolutePath();
            logger.error("Cannot read from '{}' -- file is missing or not readable", (Object)path);
            throw new IllegalArgumentException("NiFi properties file missing or unreadable");
        }
        Properties rawProperties = new Properties();
        BufferedInputStream inStream = null;
        try {
            ProtectedNiFiProperties protectedNiFiProperties;
            inStream = new BufferedInputStream(new FileInputStream(file));
            rawProperties.load(inStream);
            logger.info("Loaded {} properties from {}", (Object)rawProperties.size(), (Object)file.getAbsolutePath());
            ProtectedNiFiProperties protectedNiFiProperties2 = protectedNiFiProperties = new ProtectedNiFiProperties(rawProperties);
            return protectedNiFiProperties2;
        }
        catch (Exception ex) {
            logger.error("Cannot load properties file due to " + ex.getLocalizedMessage());
            throw new RuntimeException("Cannot load properties file due to " + ex.getLocalizedMessage(), ex);
        }
        finally {
            if (null != inStream) {
                try {
                    ((InputStream)inStream).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public NiFiProperties load(File file) {
        ProtectedNiFiProperties protectedNiFiProperties = this.readProtectedPropertiesFromDisk(file);
        if (protectedNiFiProperties.hasProtectedKeys()) {
            Security.addProvider((Provider)new BouncyCastleProvider());
            protectedNiFiProperties.addSensitivePropertyProvider(this.getSensitivePropertyProvider());
        }
        return protectedNiFiProperties.getUnprotectedProperties();
    }

    public NiFiProperties load(String path) {
        if (path != null && !path.trim().isEmpty()) {
            return this.load(new File(path));
        }
        return this.loadDefault();
    }

    public NiFiProperties get() {
        if (this.instance == null) {
            this.instance = this.loadDefault();
        }
        return this.instance;
    }
}

