/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.qpid.transport.RangeSet;
import org.apache.qpid.transport.RangeSetFactory;
import org.apache.qpid.util.Serial;

public abstract class Range
implements RangeSet {
    public static Range newInstance(int point) {
        return new PointImpl(point);
    }

    public static Range newInstance(int lower, int upper) {
        return lower == upper ? new PointImpl(lower) : new RangeImpl(lower, upper);
    }

    public abstract int getLower();

    public abstract int getUpper();

    @Override
    public abstract boolean includes(int var1);

    @Override
    public abstract boolean includes(Range var1);

    public abstract boolean intersects(Range var1);

    public abstract boolean touches(Range var1);

    public abstract Range span(Range var1);

    public abstract List<Range> subtract(Range var1);

    public Range intersect(Range range) {
        int r;
        int l = Serial.max(this.getLower(), range.getLower());
        if (Serial.gt(l, r = Serial.min(this.getUpper(), range.getUpper()))) {
            return null;
        }
        return Range.newInstance(l, r);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Iterator<Range> iterator() {
        return new RangeIterator();
    }

    @Override
    public Range getFirst() {
        return this;
    }

    @Override
    public Range getLast() {
        return this;
    }

    @Override
    public void add(Range range) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int lower, int upper) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void subtract(RangeSet rangeSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RangeSet copy() {
        RangeSet rangeSet = RangeSetFactory.createRangeSet();
        rangeSet.add(this);
        return rangeSet;
    }

    private class RangeIterator
    implements Iterator<Range> {
        private boolean atFirst = true;

        private RangeIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.atFirst;
        }

        @Override
        public Range next() {
            Range range = this.atFirst ? Range.this : null;
            this.atFirst = false;
            return range;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class RangeImpl
    extends Range {
        private final int lower;
        private final int upper;

        private RangeImpl(int lower, int upper) {
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        public int getLower() {
            return this.lower;
        }

        @Override
        public int getUpper() {
            return this.upper;
        }

        @Override
        public boolean includes(int value) {
            return Serial.le(this.lower, value) && Serial.le(value, this.upper);
        }

        @Override
        public boolean includes(Range range) {
            return this.includes(range.getLower()) && this.includes(range.getUpper());
        }

        @Override
        public boolean intersects(Range range) {
            return this.includes(range.getLower()) || this.includes(range.getUpper()) || range.includes(this.lower) || range.includes(this.upper);
        }

        @Override
        public boolean touches(Range range) {
            return this.intersects(range) || this.includes(range.getUpper() + 1) || this.includes(range.getLower() - 1) || range.includes(this.upper + 1) || range.includes(this.lower - 1);
        }

        @Override
        public Range span(Range range) {
            return RangeImpl.newInstance(Serial.min(this.lower, range.getLower()), Serial.max(this.upper, range.getUpper()));
        }

        @Override
        public List<Range> subtract(Range range) {
            ArrayList<Range> result = new ArrayList<Range>();
            if (this.includes(range.getLower()) && Serial.le(this.lower, range.getLower() - 1)) {
                result.add(RangeImpl.newInstance(this.lower, range.getLower() - 1));
            }
            if (this.includes(range.getUpper()) && Serial.le(range.getUpper() + 1, this.upper)) {
                result.add(RangeImpl.newInstance(range.getUpper() + 1, this.upper));
            }
            if (result.isEmpty() && !range.includes(this)) {
                result.add(this);
            }
            return result;
        }

        public String toString() {
            return "[" + this.lower + ", " + this.upper + "]";
        }
    }

    private static class PointImpl
    extends Range {
        private final int point;

        private PointImpl(int point) {
            this.point = point;
        }

        @Override
        public int getLower() {
            return this.point;
        }

        @Override
        public int getUpper() {
            return this.point;
        }

        @Override
        public boolean includes(int value) {
            return value == this.point;
        }

        @Override
        public boolean includes(Range range) {
            return range.getLower() == this.point && range.getUpper() == this.point;
        }

        @Override
        public boolean intersects(Range range) {
            return range.includes(this.point);
        }

        @Override
        public boolean touches(Range range) {
            return this.intersects(range) || this.includes(range.getUpper() + 1) || this.includes(range.getLower() - 1) || range.includes(this.point + 1) || range.includes(this.point - 1);
        }

        @Override
        public Range span(Range range) {
            return PointImpl.newInstance(Serial.min(this.point, range.getLower()), Serial.max(this.point, range.getUpper()));
        }

        @Override
        public List<Range> subtract(Range range) {
            if (range.includes(this.point)) {
                return Collections.emptyList();
            }
            return Collections.singletonList(this);
        }

        public String toString() {
            return "[" + this.point + ", " + this.point + "]";
        }
    }
}

