/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jsr181.xfire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.wsdl.Definition;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebFault;
import org.apache.servicemix.jsr181.xfire.JbiProxyFactoryBean;
import org.apache.servicemix.jsr181.xfire.ServiceFactoryHelper;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.client.XFireProxyFactory;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.jaxws.JAXWSServiceFactory;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.util.jdom.StaxSerializer;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class JbiProxy {
    private static final Logger logger = LoggerFactory.getLogger(JbiProxyFactoryBean.class);
    protected XFire xfire;
    protected ComponentContext context;
    protected QName interfaceName;
    protected QName serviceName;
    protected String endpointName;
    protected Object proxy;
    protected Class serviceClass;
    protected Definition description;
    protected ServiceEndpoint endpoint;
    protected boolean propagateSecurityContext;

    public JbiProxy(XFire xfire, ComponentContext context, Class serviceClass, Definition description) throws Exception {
        this.xfire = xfire;
        this.context = context;
        this.serviceClass = serviceClass;
        this.description = description;
    }

    public JbiProxy(XFire xfire, ComponentContext context, Class serviceClass, QName interfaceName, QName serviceName, String endpointName) throws Exception {
        this.xfire = xfire;
        this.context = context;
        this.interfaceName = interfaceName;
        this.serviceName = serviceName;
        this.endpointName = endpointName;
        this.serviceClass = serviceClass;
    }

    public JbiProxy(XFire xfire, ComponentContext context, Class serviceClass, QName interfaceName, QName serviceName, String endpointName, boolean propagateSecurityContext) throws Exception {
        this.xfire = xfire;
        this.context = context;
        this.interfaceName = interfaceName;
        this.serviceName = serviceName;
        this.endpointName = endpointName;
        this.serviceClass = serviceClass;
        this.propagateSecurityContext = propagateSecurityContext;
    }

    public static Object create(XFire xfire, ComponentContext context, QName interfaceName, QName serviceName, String endpointName, Class serviceClass) throws Exception {
        JbiProxy p = new JbiProxy(xfire, context, serviceClass, interfaceName, serviceName, endpointName);
        return p.getProxy();
    }

    public static Object create(XFire xfire, ComponentContext context, QName interfaceName, QName serviceName, String endpointName, Class serviceClass, boolean propagateSecurityContext) throws Exception {
        JbiProxy p = new JbiProxy(xfire, context, serviceClass, interfaceName, serviceName, endpointName, propagateSecurityContext);
        return p.getProxy();
    }

    public Object getProxy() throws Exception {
        if (this.proxy == null) {
            HashMap<String, Boolean> props = new HashMap<String, Boolean>();
            props.put("annotations.allow.interface", Boolean.TRUE);
            ObjectServiceFactory factory = ServiceFactoryHelper.findServiceFactory(this.xfire, this.serviceClass, null, null);
            Service service = factory.create(this.serviceClass, props);
            JBIClient client = factory instanceof JAXWSServiceFactory ? new JAXWSJBIClient(this.xfire, service) : new JBIClient(this.xfire, service);
            if (this.interfaceName != null) {
                client.getService().setProperty("jbi.interface", (Object)this.interfaceName);
            }
            if (this.serviceName != null) {
                client.getService().setProperty("jbi.service", (Object)this.serviceName);
            }
            if (this.endpoint != null) {
                client.getService().setProperty("jbi.endpoint", (Object)this.endpoint);
            }
            client.getService().setProperty("jbi.security.propagation", (Object)this.propagateSecurityContext);
            XFireProxyFactory xpf = new XFireProxyFactory(this.xfire);
            this.proxy = xpf.create((Client)client);
        }
        return this.proxy;
    }

    public Definition getDescription() throws Exception {
        if (this.description == null) {
            ServiceEndpoint[] endpoints = this.getEndpoints();
            if (endpoints == null || endpoints.length == 0) {
                throw new IllegalStateException("No endpoints found for interface " + this.interfaceName + ", serviceName " + this.serviceName + " and endpoint " + this.endpointName);
            }
            ServiceEndpoint ep = this.chooseEndpoint(endpoints);
            if (ep == null) {
                throw new IllegalStateException("No suitable endpoint found");
            }
            if (this.serviceName != null && this.endpointName != null) {
                this.endpoint = ep;
            }
            Document doc = this.context.getEndpointDescriptor(ep);
            WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
            reader.setFeature("javax.wsdl.verbose", false);
            this.description = reader.readWSDL(null, doc);
        }
        return this.description;
    }

    protected ServiceEndpoint[] getEndpoints() throws JBIException {
        ServiceEndpoint[] endpoints;
        if (this.endpointName != null && this.serviceName != null) {
            ServiceEndpoint ep = this.context.getEndpoint(this.serviceName, this.endpointName);
            if (ep == null) {
                endpoints = new ServiceEndpoint[]{};
            } else {
                this.endpoint = ep;
                endpoints = new ServiceEndpoint[]{ep};
            }
        } else if (this.serviceName != null) {
            endpoints = this.context.getEndpointsForService(this.serviceName);
        } else if (this.interfaceName != null) {
            endpoints = this.context.getEndpoints(this.interfaceName);
        } else {
            throw new IllegalStateException("One of interfaceName or serviceName should be provided");
        }
        return endpoints;
    }

    protected ServiceEndpoint chooseEndpoint(ServiceEndpoint[] endpoints) throws JBIException {
        for (int i = 0; i < endpoints.length; ++i) {
            if (this.context.getEndpointDescriptor(endpoints[i]) == null) continue;
            return endpoints[i];
        }
        return null;
    }

    protected static class JAXWSJBIClient
    extends JBIClient {
        public JAXWSJBIClient(XFire xfire, Service service) throws Exception {
            super(xfire, service);
        }

        public Object[] invoke(OperationInfo op, Object[] params) throws Exception {
            try {
                return super.invoke(op, params);
            }
            catch (Exception e) {
                throw this.translateException(op.getMethod(), e);
            }
        }

        protected Exception translateException(Method method, Exception t) {
            if (!(t instanceof XFireFault)) {
                logger.debug("Exception is not an XFireFault");
                return t;
            }
            XFireFault xfireFault = (XFireFault)t;
            if (!xfireFault.hasDetails()) {
                logger.debug("XFireFault has no details");
                return t;
            }
            List details = xfireFault.getDetail().getContent();
            Element detail = null;
            for (Object o : details) {
                if (!(o instanceof Element)) continue;
                detail = (Element)o;
                break;
            }
            if (detail == null) {
                logger.debug("XFireFault has no element in <detail/>");
                return t;
            }
            QName qname = new QName(detail.getNamespaceURI(), detail.getName());
            Class<?>[] exceptions = method.getExceptionTypes();
            for (int i = 0; i < exceptions.length; ++i) {
                logger.debug("Checking exception: {}", exceptions[i]);
                WebFault wf = exceptions[i].getAnnotation(WebFault.class);
                if (wf == null) {
                    logger.debug("No WebFault annotation");
                    continue;
                }
                QName exceptionName = new QName(wf.targetNamespace(), wf.name());
                if (exceptionName.equals(qname)) {
                    try {
                        Method mth = exceptions[i].getMethod("getFaultInfo", new Class[0]);
                        Class<?> infoClass = mth.getReturnType();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(baos);
                        new StaxSerializer().writeElement(detail, writer);
                        writer.close();
                        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                        JAXBElement obj = JAXBContext.newInstance((Class[])new Class[]{infoClass}).createUnmarshaller().unmarshal((Source)new StreamSource(bais), infoClass);
                        Constructor<?> cst = exceptions[i].getConstructor(String.class, infoClass);
                        return (Exception)cst.newInstance(xfireFault.toString(), obj.getValue());
                    }
                    catch (Throwable e) {
                        logger.debug("Error: {}", e);
                        continue;
                    }
                }
                logger.debug("QName mismatch: element: {}, execption: {}", (Object)qname, (Object)exceptionName);
            }
            return t;
        }
    }

    protected static class JBIClient
    extends Client {
        public JBIClient(XFire xfire, Service service) throws Exception {
            super(xfire.getTransportManager().getTransport("http://java.sun.com/xml/ns/jbi/binding/service+engine"), service, null);
            this.setXFire(xfire);
        }
    }
}

