/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jsr181.xfire;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.jbi.component.ComponentContext;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import org.apache.servicemix.jbi.api.ClientFactory;
import org.apache.servicemix.jbi.api.Container;
import org.apache.servicemix.jbi.api.ServiceMixClient;
import org.apache.servicemix.jsr181.Jsr181Component;
import org.apache.servicemix.jsr181.xfire.JbiProxy;
import org.codehaus.xfire.XFire;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class JbiProxyFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private String name = "org.apache.servicemix.jbi.ClientFactory";
    private Container container;
    private ClientFactory factory;
    private ComponentContext context;
    private Class type;
    private Object proxy;
    private InvocationHandler jbiInvocationHandler;
    private QName service;
    private QName interfaceName;
    private String endpoint;
    private boolean propagateSecuritySubject;
    private ServiceMixClient client;

    public Object getObject() throws Exception {
        if (this.proxy == null) {
            this.proxy = this.createProxy();
        }
        return this.proxy;
    }

    private Object createProxy() throws Exception {
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{this.type}, new InvocationHandler(){

            public Object invoke(Object p, Method method, Object[] args) throws Throwable {
                InvocationHandler next = JbiProxyFactoryBean.this.getJBIInvocationHandler();
                return next.invoke(p, method, args);
            }
        });
    }

    private synchronized InvocationHandler getJBIInvocationHandler() throws Exception {
        if (this.jbiInvocationHandler == null) {
            XFire xfire = Jsr181Component.createXFire(this.getInternalContext());
            Object o = JbiProxy.create(xfire, this.context, this.interfaceName, this.service, this.endpoint, this.type, this.propagateSecuritySubject);
            this.jbiInvocationHandler = Proxy.getInvocationHandler(o);
        }
        return this.jbiInvocationHandler;
    }

    public Class getObjectType() {
        return this.type;
    }

    public boolean isSingleton() {
        return true;
    }

    protected ComponentContext getInternalContext() throws Exception {
        if (this.context == null) {
            if (this.factory == null) {
                this.factory = this.container != null ? this.container.getClientFactory() : (ClientFactory)new InitialContext().lookup(this.name);
            }
            this.client = this.factory.createClient();
            this.context = this.client.getContext();
        }
        return this.context;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpointName) {
        this.endpoint = endpointName;
    }

    public QName getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(QName interfaceName) {
        this.interfaceName = interfaceName;
    }

    public QName getService() {
        return this.service;
    }

    public void setService(QName service) {
        this.service = service;
    }

    public ComponentContext getContext() {
        return this.context;
    }

    public void setContext(ComponentContext context) {
        this.context = context;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public ClientFactory getFactory() {
        return this.factory;
    }

    public void setFactory(ClientFactory factory) {
        this.factory = factory;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isPropagateSecuritySubject() {
        return this.propagateSecuritySubject;
    }

    public void setPropagateSecuritySubject(boolean propagateSecuritySubject) {
        this.propagateSecuritySubject = propagateSecuritySubject;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.type == null) {
            throw new IllegalArgumentException("type must be set");
        }
    }

    public void destroy() throws Exception {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }
}

