/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.orchestration.internal.datasource;

import com.google.common.eventbus.Subscribe;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.shardingsphere.orchestration.internal.eventbus.ShardingOrchestrationEventBus;
import org.apache.shardingsphere.orchestration.internal.registry.ShardingOrchestrationFacade;
import org.apache.shardingsphere.orchestration.internal.registry.state.event.CircuitStateChangedEvent;
import org.apache.shardingsphere.shardingjdbc.jdbc.adapter.AbstractDataSourceAdapter;
import org.apache.shardingsphere.shardingjdbc.jdbc.unsupported.AbstractUnsupportedOperationDataSource;
import org.apache.shardingsphere.shardingjdbc.orchestration.internal.circuit.datasource.CircuitBreakerDataSource;

public abstract class AbstractOrchestrationDataSource
extends AbstractUnsupportedOperationDataSource
implements AutoCloseable {
    private PrintWriter logWriter = new PrintWriter(System.out);
    private final ShardingOrchestrationFacade shardingOrchestrationFacade;
    private boolean isCircuitBreak;

    public AbstractOrchestrationDataSource(ShardingOrchestrationFacade shardingOrchestrationFacade) {
        this.shardingOrchestrationFacade = shardingOrchestrationFacade;
        ShardingOrchestrationEventBus.getInstance().register((Object)this);
    }

    protected abstract DataSource getDataSource();

    public final Connection getConnection() throws SQLException {
        return this.isCircuitBreak ? new CircuitBreakerDataSource().getConnection() : this.getDataSource().getConnection();
    }

    public final Connection getConnection(String username, String password) {
        return this.getConnection();
    }

    public final Logger getParentLogger() {
        return Logger.getLogger("global");
    }

    @Override
    public final void close() throws Exception {
        ((AbstractDataSourceAdapter)this.getDataSource()).close();
        this.shardingOrchestrationFacade.close();
    }

    @Subscribe
    public final synchronized void renew(CircuitStateChangedEvent circuitStateChangedEvent) {
        this.isCircuitBreak = circuitStateChangedEvent.isCircuitBreak();
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    protected ShardingOrchestrationFacade getShardingOrchestrationFacade() {
        return this.shardingOrchestrationFacade;
    }
}

