/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.orchestration.internal.datasource;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shardingsphere.api.config.RuleConfiguration;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;
import org.apache.shardingsphere.core.rule.MasterSlaveRule;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.orchestration.config.OrchestrationConfiguration;
import org.apache.shardingsphere.orchestration.internal.registry.ShardingOrchestrationFacade;
import org.apache.shardingsphere.orchestration.internal.registry.config.event.DataSourceChangedEvent;
import org.apache.shardingsphere.orchestration.internal.registry.config.event.PropertiesChangedEvent;
import org.apache.shardingsphere.orchestration.internal.registry.config.event.ShardingRuleChangedEvent;
import org.apache.shardingsphere.orchestration.internal.registry.config.service.ConfigurationService;
import org.apache.shardingsphere.orchestration.internal.registry.state.event.DisabledStateChangedEvent;
import org.apache.shardingsphere.orchestration.internal.registry.state.schema.OrchestrationShardingSchema;
import org.apache.shardingsphere.orchestration.internal.rule.OrchestrationMasterSlaveRule;
import org.apache.shardingsphere.orchestration.internal.rule.OrchestrationShardingRule;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.ShardingDataSource;
import org.apache.shardingsphere.shardingjdbc.orchestration.internal.datasource.AbstractOrchestrationDataSource;
import org.apache.shardingsphere.shardingjdbc.orchestration.internal.util.DataSourceConverter;

public class OrchestrationShardingDataSource
extends AbstractOrchestrationDataSource {
    private ShardingDataSource dataSource;

    public OrchestrationShardingDataSource(OrchestrationConfiguration orchestrationConfig) throws SQLException {
        super(new ShardingOrchestrationFacade(orchestrationConfig, Collections.singletonList("logic_db")));
        ConfigurationService configService = this.getShardingOrchestrationFacade().getConfigService();
        ShardingRuleConfiguration shardingRuleConfig = configService.loadShardingRuleConfiguration("logic_db");
        Preconditions.checkState((null != shardingRuleConfig && !shardingRuleConfig.getTableRuleConfigs().isEmpty() ? 1 : 0) != 0, (Object)"Missing the sharding rule configuration on registry center");
        this.dataSource = new ShardingDataSource(DataSourceConverter.getDataSourceMap(configService.loadDataSourceConfigurations("logic_db")), (ShardingRule)new OrchestrationShardingRule(shardingRuleConfig, configService.loadDataSourceConfigurations("logic_db").keySet()), configService.loadProperties());
        this.getShardingOrchestrationFacade().init();
    }

    public OrchestrationShardingDataSource(ShardingDataSource shardingDataSource, OrchestrationConfiguration orchestrationConfig) throws SQLException {
        super(new ShardingOrchestrationFacade(orchestrationConfig, Collections.singletonList("logic_db")));
        this.dataSource = new ShardingDataSource(shardingDataSource.getDataSourceMap(), (ShardingRule)new OrchestrationShardingRule(shardingDataSource.getShardingContext().getShardingRule().getShardingRuleConfig(), shardingDataSource.getDataSourceMap().keySet()), shardingDataSource.getShardingContext().getShardingProperties().getProps());
        this.getShardingOrchestrationFacade().init(Collections.singletonMap("logic_db", DataSourceConverter.getDataSourceConfigurationMap(this.dataSource.getDataSourceMap())), this.getRuleConfigurationMap(), null, this.dataSource.getShardingContext().getShardingProperties().getProps());
    }

    private Map<String, RuleConfiguration> getRuleConfigurationMap() {
        LinkedHashMap<String, RuleConfiguration> result = new LinkedHashMap<String, RuleConfiguration>(1, 1.0f);
        result.put("logic_db", (RuleConfiguration)this.dataSource.getShardingContext().getShardingRule().getShardingRuleConfig());
        return result;
    }

    @Subscribe
    public final synchronized void renew(ShardingRuleChangedEvent shardingRuleChangedEvent) {
        this.dataSource = new ShardingDataSource(this.dataSource.getDataSourceMap(), (ShardingRule)new OrchestrationShardingRule(shardingRuleChangedEvent.getShardingRuleConfiguration(), this.dataSource.getDataSourceMap().keySet()), this.dataSource.getShardingContext().getShardingProperties().getProps());
    }

    @Subscribe
    public final synchronized void renew(DataSourceChangedEvent dataSourceChangedEvent) {
        this.dataSource.close();
        this.dataSource = new ShardingDataSource(DataSourceConverter.getDataSourceMap(dataSourceChangedEvent.getDataSourceConfigurations()), this.dataSource.getShardingContext().getShardingRule(), this.dataSource.getShardingContext().getShardingProperties().getProps());
    }

    @Subscribe
    public final synchronized void renew(PropertiesChangedEvent propertiesChangedEvent) {
        this.dataSource = new ShardingDataSource(this.dataSource.getDataSourceMap(), this.dataSource.getShardingContext().getShardingRule(), propertiesChangedEvent.getProps());
    }

    @Subscribe
    public synchronized void renew(DisabledStateChangedEvent disabledStateChangedEvent) {
        OrchestrationShardingSchema shardingSchema = disabledStateChangedEvent.getShardingSchema();
        if ("logic_db".equals(shardingSchema.getSchemaName())) {
            for (MasterSlaveRule each : this.dataSource.getShardingContext().getShardingRule().getMasterSlaveRules()) {
                ((OrchestrationMasterSlaveRule)each).updateDisabledDataSourceNames(shardingSchema.getDataSourceName(), disabledStateChangedEvent.isDisabled());
            }
        }
    }

    protected ShardingDataSource getDataSource() {
        return this.dataSource;
    }
}

