/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.spring.namespace.parser;

import com.google.common.base.Strings;
import lombok.Generated;
import org.apache.shardingsphere.api.config.sharding.strategy.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.api.config.sharding.strategy.HintShardingStrategyConfiguration;
import org.apache.shardingsphere.api.config.sharding.strategy.InlineShardingStrategyConfiguration;
import org.apache.shardingsphere.api.config.sharding.strategy.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.api.config.sharding.strategy.StandardShardingStrategyConfiguration;
import org.apache.shardingsphere.underlying.common.exception.ShardingSphereException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.w3c.dom.Element;

public final class ShardingStrategyBeanDefinition {
    static AbstractBeanDefinition getBeanDefinitionByElement(Element element) {
        String type;
        switch (type = element.getLocalName()) {
            case "standard-strategy": {
                return ShardingStrategyBeanDefinition.getStandardShardingStrategyConfigBeanDefinition(element);
            }
            case "complex-strategy": {
                return ShardingStrategyBeanDefinition.getComplexShardingStrategyConfigBeanDefinition(element);
            }
            case "inline-strategy": {
                return ShardingStrategyBeanDefinition.getInlineShardingStrategyConfigBeanDefinition(element);
            }
            case "hint-strategy": {
                return ShardingStrategyBeanDefinition.getHintShardingStrategyConfigBeanDefinition(element);
            }
            case "none-strategy": {
                return ShardingStrategyBeanDefinition.getNoneShardingStrategyConfigBeanDefinition();
            }
        }
        throw new ShardingSphereException("Cannot support type: %s", new Object[]{type});
    }

    private static AbstractBeanDefinition getStandardShardingStrategyConfigBeanDefinition(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(StandardShardingStrategyConfiguration.class);
        factory.addConstructorArgValue((Object)element.getAttribute("sharding-column"));
        factory.addConstructorArgReference(element.getAttribute("precise-algorithm-ref"));
        if (!Strings.isNullOrEmpty((String)element.getAttribute("range-algorithm-ref"))) {
            factory.addConstructorArgReference(element.getAttribute("range-algorithm-ref"));
        }
        return factory.getBeanDefinition();
    }

    private static AbstractBeanDefinition getComplexShardingStrategyConfigBeanDefinition(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(ComplexShardingStrategyConfiguration.class);
        factory.addConstructorArgValue((Object)element.getAttribute("sharding-columns"));
        factory.addConstructorArgReference(element.getAttribute("algorithm-ref"));
        return factory.getBeanDefinition();
    }

    private static AbstractBeanDefinition getInlineShardingStrategyConfigBeanDefinition(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(InlineShardingStrategyConfiguration.class);
        factory.addConstructorArgValue((Object)element.getAttribute("sharding-column"));
        factory.addConstructorArgValue((Object)element.getAttribute("algorithm-expression"));
        return factory.getBeanDefinition();
    }

    private static AbstractBeanDefinition getHintShardingStrategyConfigBeanDefinition(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(HintShardingStrategyConfiguration.class);
        factory.addConstructorArgReference(element.getAttribute("algorithm-ref"));
        return factory.getBeanDefinition();
    }

    private static AbstractBeanDefinition getNoneShardingStrategyConfigBeanDefinition() {
        return BeanDefinitionBuilder.rootBeanDefinition(NoneShardingStrategyConfiguration.class).getBeanDefinition();
    }

    @Generated
    private ShardingStrategyBeanDefinition() {
    }
}

