/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.sm.algorithm;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.encrypt.spi.context.EncryptContext;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public final class SM4EncryptAlgorithm
implements EncryptAlgorithm<Object, String> {
    private static final String SM4_KEY = "sm4-key";
    private static final String SM4_IV = "sm4-iv";
    private static final String SM4_MODE = "sm4-mode";
    private static final String SM4_PADDING = "sm4-padding";
    private static final int KEY_LENGTH = 16;
    private static final int IV_LENGTH = 16;
    private static final Set<String> MODES;
    private static final Set<String> PADDINGS;
    private Properties props;
    private byte[] sm4Key;
    private byte[] sm4Iv;
    private String sm4ModePadding;

    public void init(Properties props) {
        this.props = props;
        String sm4Mode = this.createSm4Mode(props);
        String sm4Padding = this.createSm4Padding(props);
        this.sm4ModePadding = "SM4/" + sm4Mode + "/" + sm4Padding;
        this.sm4Key = this.createSm4Key(props);
        this.sm4Iv = this.createSm4Iv(props, sm4Mode);
    }

    private String createSm4Mode(Properties props) {
        Preconditions.checkArgument((boolean)props.containsKey(SM4_MODE), (String)"%s can not be null.", (Object)SM4_MODE);
        String result = String.valueOf(props.getProperty(SM4_MODE)).toUpperCase();
        Preconditions.checkState((boolean)MODES.contains(result), (Object)"Mode must be either CBC or ECB.");
        return result;
    }

    private byte[] createSm4Key(Properties props) {
        Preconditions.checkArgument((boolean)props.containsKey(SM4_KEY), (String)"%s can not be null.", (Object)SM4_KEY);
        byte[] result = ByteUtils.fromHexString((String)String.valueOf(props.getProperty(SM4_KEY)));
        Preconditions.checkState((16 == result.length ? 1 : 0) != 0, (Object)"Key length must be 16 bytes long.");
        return result;
    }

    private byte[] createSm4Iv(Properties props, String sm4Mode) {
        if (!"CBC".equalsIgnoreCase(sm4Mode)) {
            return null;
        }
        Preconditions.checkArgument((boolean)props.containsKey(SM4_IV), (String)"%s can not be null.", (Object)SM4_IV);
        String sm4IvValue = String.valueOf(props.getProperty(SM4_IV));
        byte[] result = ByteUtils.fromHexString((String)sm4IvValue);
        Preconditions.checkState((16 == result.length ? 1 : 0) != 0, (Object)"Iv length must be 16 bytes long.");
        return result;
    }

    private String createSm4Padding(Properties props) {
        Preconditions.checkArgument((boolean)props.containsKey(SM4_PADDING), (String)"%s can not be null.", (Object)SM4_PADDING);
        String result = String.valueOf(props.getProperty(SM4_PADDING)).toUpperCase().replace("PADDING", "Padding");
        Preconditions.checkState((boolean)PADDINGS.contains(result), (Object)"Padding must be either PKCS5Padding or PKCS7Padding.");
        return result;
    }

    public String encrypt(Object plainValue, EncryptContext encryptContext) {
        return null == plainValue ? null : ByteUtils.toHexString((byte[])this.encrypt(String.valueOf(plainValue).getBytes(StandardCharsets.UTF_8)));
    }

    private byte[] encrypt(byte[] plainValue) {
        return this.handle(plainValue, 1);
    }

    public Object decrypt(String cipherValue, EncryptContext encryptContext) {
        return null == cipherValue ? null : new String(this.decrypt(ByteUtils.fromHexString((String)cipherValue)), StandardCharsets.UTF_8);
    }

    private byte[] decrypt(byte[] cipherValue) {
        return this.handle(cipherValue, 2);
    }

    private byte[] handle(byte[] input, int mode) {
        Cipher cipher = Cipher.getInstance(this.sm4ModePadding, "BC");
        SecretKeySpec secretKeySpec = new SecretKeySpec(this.sm4Key, "SM4");
        Optional<byte[]> sm4Iv = Optional.ofNullable(this.sm4Iv);
        if (sm4Iv.isPresent()) {
            cipher.init(mode, (Key)secretKeySpec, new IvParameterSpec(sm4Iv.get()));
        } else {
            cipher.init(mode, secretKeySpec);
        }
        return cipher.doFinal(input);
    }

    public String getType() {
        return "SM4";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        MODES = new HashSet<String>(Arrays.asList("ECB", "CBC"));
        PADDINGS = new HashSet<String>(Arrays.asList("PKCS5Padding", "PKCS7Padding"));
    }
}

