/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.ddl;

import java.util.Collection;
import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.IndexAvailable;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtils;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexNameSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class CreateIndexStatementContext
extends CommonSQLStatementContext
implements TableAvailable,
IndexAvailable {
    private final TablesContext tablesContext;
    private final boolean generatedIndex;

    public CreateIndexStatementContext(CreateIndexStatement sqlStatement, String currentDatabaseName) {
        super((SQLStatement)sqlStatement);
        this.tablesContext = new TablesContext(sqlStatement.getTable(), this.getDatabaseType(), currentDatabaseName);
        this.generatedIndex = null == sqlStatement.getIndex();
    }

    public CreateIndexStatement getSqlStatement() {
        return (CreateIndexStatement)super.getSqlStatement();
    }

    @Override
    public Collection<IndexSegment> getIndexes() {
        if (null == this.getSqlStatement().getIndex()) {
            return this.getSqlStatement().getGeneratedIndexStartIndex().map(each -> Collections.singletonList(new IndexSegment(each.intValue(), each.intValue(), new IndexNameSegment(each.intValue(), each.intValue(), new IdentifierValue(IndexMetaDataUtils.getGeneratedLogicIndexName((Collection)this.getSqlStatement().getColumns())))))).orElseGet(Collections::emptyList);
        }
        return Collections.singleton(this.getSqlStatement().getIndex());
    }

    @Override
    public Collection<ColumnSegment> getIndexColumns() {
        return this.getSqlStatement().getColumns();
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }

    @Generated
    public boolean isGeneratedIndex() {
        return this.generatedIndex;
    }
}

