/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.util;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.extractor.ProjectionIdentifierExtractEngine;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.AliasAvailable;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.bound.ColumnSegmentBoundInfo;
import org.apache.shardingsphere.sql.parser.statement.core.value.identifier.IdentifierValue;

public final class SubqueryTableBindUtils {
    public static Collection<ProjectionSegment> createSubqueryProjections(Collection<ProjectionSegment> projections, IdentifierValue subqueryTableName, DatabaseType databaseType) {
        LinkedList<ProjectionSegment> result = new LinkedList<ProjectionSegment>();
        for (ProjectionSegment each : projections) {
            if (each instanceof ColumnProjectionSegment) {
                result.add((ProjectionSegment)SubqueryTableBindUtils.createColumnProjection((ColumnProjectionSegment)each, subqueryTableName));
                continue;
            }
            if (each instanceof ShorthandProjectionSegment) {
                result.addAll(SubqueryTableBindUtils.createSubqueryProjections(((ShorthandProjectionSegment)each).getActualProjectionSegments(), subqueryTableName, databaseType));
                continue;
            }
            if (each instanceof ExpressionProjectionSegment) {
                result.add((ProjectionSegment)SubqueryTableBindUtils.createColumnProjection((ExpressionSegment)((ExpressionProjectionSegment)each), subqueryTableName, databaseType));
                continue;
            }
            if (each instanceof AggregationProjectionSegment) {
                result.add((ProjectionSegment)SubqueryTableBindUtils.createColumnProjection((ExpressionSegment)((AggregationProjectionSegment)each), subqueryTableName, databaseType));
                continue;
            }
            result.add(each);
        }
        return result;
    }

    private static ColumnProjectionSegment createColumnProjection(ColumnProjectionSegment originalColumn, IdentifierValue subqueryTableName) {
        ColumnSegment newColumnSegment = new ColumnSegment(0, 0, originalColumn.getAlias().orElseGet(() -> originalColumn.getColumn().getIdentifier()));
        if (!Strings.isNullOrEmpty((String)subqueryTableName.getValue())) {
            newColumnSegment.setOwner(new OwnerSegment(0, 0, subqueryTableName));
        }
        newColumnSegment.setColumnBoundInfo(new ColumnSegmentBoundInfo(originalColumn.getColumn().getColumnBoundInfo().getOriginalDatabase(), originalColumn.getColumn().getColumnBoundInfo().getOriginalSchema(), originalColumn.getColumn().getColumnBoundInfo().getOriginalTable(), originalColumn.getColumn().getColumnBoundInfo().getOriginalColumn()));
        ColumnProjectionSegment result = new ColumnProjectionSegment(newColumnSegment);
        result.setVisible(originalColumn.isVisible());
        return result;
    }

    private static ColumnProjectionSegment createColumnProjection(ExpressionSegment expressionSegment, IdentifierValue subqueryTableName, DatabaseType databaseType) {
        ColumnSegment newColumnSegment = new ColumnSegment(0, 0, new IdentifierValue(SubqueryTableBindUtils.getColumnNameFromExpression(expressionSegment, databaseType), new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData().getQuoteCharacter()));
        if (!Strings.isNullOrEmpty((String)subqueryTableName.getValue())) {
            newColumnSegment.setOwner(new OwnerSegment(0, 0, subqueryTableName));
        }
        ColumnProjectionSegment result = new ColumnProjectionSegment(newColumnSegment);
        result.setVisible(true);
        return result;
    }

    private static String getColumnNameFromExpression(ExpressionSegment expressionSegment, DatabaseType databaseType) {
        ProjectionIdentifierExtractEngine extractEngine = new ProjectionIdentifierExtractEngine(databaseType);
        if (expressionSegment instanceof AliasAvailable && ((AliasAvailable)expressionSegment).getAlias().isPresent()) {
            return extractEngine.getIdentifierValue((IdentifierValue)((AliasAvailable)expressionSegment).getAlias().get());
        }
        return extractEngine.getColumnNameFromExpression(expressionSegment.getText());
    }

    @Generated
    private SubqueryTableBindUtils() {
    }
}

