/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.executor.original;

import java.util.Map;
import lombok.Generated;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.shardingsphere.infra.federation.executor.original.FederationTableStatistic;
import org.apache.shardingsphere.infra.federation.executor.original.table.FilterableTable;
import org.apache.shardingsphere.infra.federation.executor.original.table.FilterableTableScanExecutor;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationSchemaMetaData;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationTableMetaData;

public final class FilterableSchema
extends AbstractSchema {
    private final String name;
    private final Map<String, Table> tableMap;

    public FilterableSchema(FederationSchemaMetaData schemaMetaData, FilterableTableScanExecutor executor) {
        this.name = schemaMetaData.getName();
        this.tableMap = this.createTableMap(schemaMetaData, executor);
    }

    private Map<String, Table> createTableMap(FederationSchemaMetaData schemaMetaData, FilterableTableScanExecutor executor) {
        LinkedMap result = new LinkedMap(schemaMetaData.getTables().size(), 1.0f);
        for (FederationTableMetaData each : schemaMetaData.getTables().values()) {
            result.put(each.getName(), new FilterableTable(each, executor, new FederationTableStatistic()));
        }
        return result;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, Table> getTableMap() {
        return this.tableMap;
    }
}

