/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.optimize.converter.segment.expression.impl;

import java.util.Optional;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.optimize.converter.segment.SQLSegmentConverter;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;

public final class LiteralExpressionConverter
implements SQLSegmentConverter<LiteralExpressionSegment, SqlNode> {
    @Override
    public Optional<SqlNode> convertToSQLNode(LiteralExpressionSegment segment) {
        if (Integer.class == segment.getLiterals().getClass()) {
            return Optional.of(SqlLiteral.createExactNumeric((String)String.valueOf(segment.getLiterals()), (SqlParserPos)SqlParserPos.ZERO));
        }
        if (String.class == segment.getLiterals().getClass()) {
            return Optional.of(SqlLiteral.createCharString((String)((String)segment.getLiterals()), (SqlParserPos)SqlParserPos.ZERO));
        }
        return Optional.empty();
    }

    @Override
    public Optional<LiteralExpressionSegment> convertToSQLSegment(SqlNode sqlNode) {
        if (sqlNode instanceof SqlLiteral) {
            SqlLiteral sqlLiteral = (SqlLiteral)sqlNode;
            return Optional.of(new LiteralExpressionSegment(this.getStartIndex((SqlNode)sqlLiteral), this.getStopIndex((SqlNode)sqlLiteral), (Object)SQLUtil.getExactlyValue((String)sqlLiteral.toValue())));
        }
        return Optional.empty();
    }
}

