/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.parser.hook;

import java.util.Collection;
import java.util.LinkedList;
import java.util.ServiceLoader;
import org.apache.shardingsphere.infra.parser.hook.ParsingHook;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class ParsingHookRegistry {
    private static final ParsingHookRegistry INSTANCE = new ParsingHookRegistry();
    private final Collection<ParsingHook> hooks = new LinkedList<ParsingHook>();

    private ParsingHookRegistry() {
        for (ParsingHook each : ServiceLoader.load(ParsingHook.class)) {
            this.hooks.add(each);
        }
    }

    public static ParsingHookRegistry getInstance() {
        return INSTANCE;
    }

    public void start(String sql) {
        this.hooks.forEach(each -> each.start(sql));
    }

    public void finishSuccess(SQLStatement sqlStatement) {
        this.hooks.forEach(each -> each.finishSuccess(sqlStatement));
    }

    public void finishFailure(Exception cause) {
        this.hooks.forEach(each -> each.finishFailure(cause));
    }
}

