/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.spring.boot.datasource;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.datasource.pool.creator.DataSourcePoolCreator;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.util.expr.InlineExpressionParser;
import org.apache.shardingsphere.spring.boot.datasource.AopProxyUtils;
import org.apache.shardingsphere.spring.boot.exception.DataSourceJndiNotFoundException;
import org.apache.shardingsphere.spring.boot.exception.UnsupportedDataSourceTypeException;
import org.apache.shardingsphere.spring.boot.util.PropertyUtil;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.jndi.JndiObjectFactoryBean;

public final class DataSourceMapSetter {
    private static final String PREFIX = "spring.shardingsphere.datasource.";
    private static final String DATA_SOURCE_NAME = "name";
    private static final String DATA_SOURCE_NAMES = "names";
    private static final String DATA_SOURCE_TYPE = "type";
    private static final String JNDI_NAME = "jndi-name";

    public static Map<String, DataSource> getDataSourceMap(Environment environment) {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>();
        for (String each : DataSourceMapSetter.getDataSourceNames(environment)) {
            try {
                result.put(each, DataSourceMapSetter.getDataSource(environment, each));
            }
            catch (ReflectiveOperationException ex) {
                throw new UnsupportedDataSourceTypeException(ex);
            }
            catch (NamingException ex) {
                throw new DataSourceJndiNotFoundException(ex);
            }
        }
        return result;
    }

    private static List<String> getDataSourceNames(Environment environment) {
        StandardEnvironment standardEnv = (StandardEnvironment)environment;
        standardEnv.setIgnoreUnresolvableNestedPlaceholders(true);
        String dataSourceNames = standardEnv.getProperty("spring.shardingsphere.datasource.name");
        if (Strings.isNullOrEmpty((String)dataSourceNames)) {
            dataSourceNames = standardEnv.getProperty("spring.shardingsphere.datasource.names");
        }
        return new InlineExpressionParser(dataSourceNames).splitAndEvaluate();
    }

    private static DataSource getDataSource(Environment environment, String dataSourceName) throws ReflectiveOperationException, NamingException {
        Map dataSourceProps = PropertyUtil.handle(environment, String.join((CharSequence)"", PREFIX, dataSourceName), Map.class);
        Preconditions.checkState((!dataSourceProps.isEmpty() ? 1 : 0) != 0, (String)"Wrong datasource [%s] properties.", (Object)dataSourceName);
        if (dataSourceProps.containsKey(JNDI_NAME)) {
            return DataSourceMapSetter.getJNDIDataSource(dataSourceProps.get(JNDI_NAME).toString());
        }
        return DataSourcePoolCreator.create((DataSourceProperties)new DataSourceProperties(dataSourceProps.get(DATA_SOURCE_TYPE).toString(), PropertyUtil.getCamelCaseKeys(dataSourceProps)));
    }

    private static DataSource getJNDIDataSource(String jndiName) throws NamingException {
        JndiObjectFactoryBean bean = new JndiObjectFactoryBean();
        bean.setResourceRef(true);
        bean.setJndiName(jndiName);
        bean.setProxyInterface(DataSource.class);
        bean.afterPropertiesSet();
        return (DataSource)AopProxyUtils.getTarget(bean.getObject());
    }

    @Generated
    private DataSourceMapSetter() {
    }
}

