/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.executor.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.authority.rule.AuthorityRule;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereRowData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereTableData;
import org.apache.shardingsphere.infra.metadata.user.Grantee;

public final class StatisticsAssembleUtils {
    public static ShardingSphereTableData assembleTableData(ShardingSphereTable table, ShardingSphereMetaData metaData) {
        ShardingSphereTableData result = new ShardingSphereTableData(table.getName());
        if ("pg_database".equalsIgnoreCase(table.getName())) {
            StatisticsAssembleUtils.assembleOpenGaussDatabaseData(result, metaData.getDatabases().values());
        } else if ("pg_tables".equalsIgnoreCase(table.getName())) {
            for (ShardingSphereDatabase each : metaData.getDatabases().values()) {
                StatisticsAssembleUtils.assembleOpenGaussTableData(result, each.getSchemas());
            }
        } else if ("pg_roles".equalsIgnoreCase(table.getName())) {
            StatisticsAssembleUtils.assembleOpenGaussRoleData(result, metaData);
        }
        return result;
    }

    private static void assembleOpenGaussDatabaseData(ShardingSphereTableData tableData, Collection<ShardingSphereDatabase> databases) {
        for (ShardingSphereDatabase each : databases) {
            Object[] rows = new Object[15];
            rows[0] = each.getName();
            rows[11] = "PG";
            tableData.getRows().add(new ShardingSphereRowData(Arrays.asList(rows)));
        }
    }

    private static void assembleOpenGaussTableData(ShardingSphereTableData tableData, Map<String, ShardingSphereSchema> schemas) {
        for (Map.Entry<String, ShardingSphereSchema> entry : schemas.entrySet()) {
            for (String each : entry.getValue().getAllTableNames()) {
                Object[] rows = new Object[10];
                rows[0] = entry.getKey();
                rows[1] = each;
                tableData.getRows().add(new ShardingSphereRowData(Arrays.asList(rows)));
            }
        }
    }

    private static void assembleOpenGaussRoleData(ShardingSphereTableData tableData, ShardingSphereMetaData metaData) {
        for (Grantee each : ((AuthorityRule)metaData.getGlobalRuleMetaData().getSingleRule(AuthorityRule.class)).getGrantees()) {
            Object[] rows = new Object[27];
            rows[0] = each.getUsername();
            tableData.getRows().add(new ShardingSphereRowData(Arrays.asList(rows)));
        }
    }

    @Generated
    private StatisticsAssembleUtils() {
    }
}

