/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.database.parser;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.spi.DatabaseTypedSQLParserFacade;

public final class DatabaseTypedSQLParserFacadeRegistry {
    private static final Map<String, DatabaseTypedSQLParserFacade> FACADES = new HashMap<String, DatabaseTypedSQLParserFacade>();

    public static DatabaseTypedSQLParserFacade getFacade(String databaseType) {
        Preconditions.checkArgument((boolean)FACADES.containsKey(databaseType), (String)"Cannot support database type '%s'", (Object)databaseType);
        return FACADES.get(databaseType);
    }

    @Generated
    private DatabaseTypedSQLParserFacadeRegistry() {
    }

    static {
        for (DatabaseTypedSQLParserFacade each : ServiceLoader.load(DatabaseTypedSQLParserFacade.class)) {
            FACADES.put(each.getDatabaseType(), each);
        }
    }
}

