/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.extractor.ddl;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.core.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.sql.parser.core.extractor.util.RuleName;
import org.apache.shardingsphere.sql.parser.sql.segment.ddl.constraint.ConstraintDefinitionSegment;

public final class SQLServerAddPrimaryKeyExtractor
implements OptionalSQLSegmentExtractor {
    public Optional<ConstraintDefinitionSegment> extract(ParserRuleContext ancestorNode, Map<ParserRuleContext, Integer> parameterMarkerIndexes) {
        Optional addColumnNode = ExtractorUtils.findFirstChildNode((ParserRuleContext)ancestorNode, (RuleName)RuleName.ADD_COLUMN_SPECIFICATION);
        if (!addColumnNode.isPresent()) {
            return Optional.absent();
        }
        Optional tableConstraintNode = ExtractorUtils.findFirstChildNode((ParserRuleContext)((ParserRuleContext)addColumnNode.get()), (RuleName)RuleName.TABLE_CONSTRAINT);
        if (!tableConstraintNode.isPresent()) {
            return Optional.absent();
        }
        Optional primaryKeyNode = ExtractorUtils.findFirstChildNode((ParserRuleContext)((ParserRuleContext)tableConstraintNode.get()), (RuleName)RuleName.PRIMARY_KEY);
        if (!primaryKeyNode.isPresent()) {
            return Optional.absent();
        }
        Collection columnNameNodes = ExtractorUtils.getAllDescendantNodes((ParserRuleContext)((ParserRuleContext)tableConstraintNode.get()), (RuleName)RuleName.COLUMN_NAME);
        if (columnNameNodes.isEmpty()) {
            return Optional.absent();
        }
        ConstraintDefinitionSegment result = new ConstraintDefinitionSegment(((ParserRuleContext)tableConstraintNode.get()).getStart().getStartIndex(), ((ParserRuleContext)tableConstraintNode.get()).getStop().getStopIndex());
        for (ParseTree each : columnNameNodes) {
            result.getPrimaryKeyColumnNames().add(each.getText());
        }
        return Optional.of((Object)result);
    }
}

