/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.xa.narayana.manager;

import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.jbossatx.jta.RecoveryManagerService;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import java.util.Objects;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import lombok.Generated;
import org.apache.shardingsphere.transaction.xa.narayana.manager.DataSourceXAResourceRecoveryHelper;
import org.apache.shardingsphere.transaction.xa.spi.SingleXAResource;
import org.apache.shardingsphere.transaction.xa.spi.XATransactionManagerProvider;

public final class NarayanaXATransactionManagerProvider
implements XATransactionManagerProvider {
    private TransactionManager transactionManager;
    private XARecoveryModule xaRecoveryModule;
    private RecoveryManagerService recoveryManagerService;

    public void init() {
        this.transactionManager = jtaPropertyManager.getJTAEnvironmentBean().getTransactionManager();
        this.xaRecoveryModule = XARecoveryModule.getRegisteredXARecoveryModule();
        this.recoveryManagerService = new RecoveryManagerService();
        RecoveryManager.delayRecoveryManagerThread();
        this.recoveryManagerService.create();
        this.recoveryManagerService.start();
    }

    public void registerRecoveryResource(String dataSourceName, XADataSource xaDataSource) {
        if (Objects.nonNull(this.xaRecoveryModule)) {
            this.xaRecoveryModule.addXAResourceRecoveryHelper((XAResourceRecoveryHelper)new DataSourceXAResourceRecoveryHelper(xaDataSource));
        }
    }

    public void removeRecoveryResource(String dataSourceName, XADataSource xaDataSource) {
        if (Objects.nonNull(this.xaRecoveryModule)) {
            this.xaRecoveryModule.removeXAResourceRecoveryHelper((XAResourceRecoveryHelper)new DataSourceXAResourceRecoveryHelper(xaDataSource));
        }
    }

    public void enlistResource(SingleXAResource singleXAResource) {
        this.transactionManager.getTransaction().enlistResource(singleXAResource.getDelegate());
    }

    public void close() throws Exception {
        this.recoveryManagerService.stop();
        this.recoveryManagerService.destroy();
    }

    public String getType() {
        return "Narayana";
    }

    @Generated
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }
}

