/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.strings;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.detect.FileCommandDetector;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.external.ExternalParser;
import org.apache.tika.parser.strings.StringsConfig;
import org.apache.tika.parser.strings.StringsEncoding;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.SystemUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class StringsParser
implements Parser,
Initializable {
    private static final long serialVersionUID = 802566634661575025L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.OCTET_STREAM);
    private final StringsConfig defaultStringsConfig = new StringsConfig();
    private String filePath = "";
    private FileCommandDetector fileCommandDetector;
    private boolean stringsPresent = false;
    private boolean hasEncodingOption = false;
    private String stringsPath = "";

    public static String getStringsProg() {
        return SystemUtils.IS_OS_WINDOWS ? "strings.exe" : "strings";
    }

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        if (!this.stringsPresent) {
            return;
        }
        StringsConfig stringsConfig = (StringsConfig)context.get(StringsConfig.class, (Object)this.defaultStringsConfig);
        try (TemporaryResources tmp = new TemporaryResources();){
            TikaInputStream tis = TikaInputStream.get((InputStream)stream, (TemporaryResources)tmp, (Metadata)metadata);
            File input = tis.getFile();
            metadata.set("strings:min-len", "" + stringsConfig.getMinLength());
            metadata.set("strings:encoding", stringsConfig.toString());
            metadata.set("strings:file_output", this.doFile(tis));
            int totalBytes = 0;
            XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
            xhtml.startDocument();
            totalBytes = this.doStrings(input, stringsConfig, xhtml);
            xhtml.endDocument();
            metadata.set("strings:length", "" + totalBytes);
        }
    }

    private String doFile(TikaInputStream tis) throws IOException {
        Metadata tmpMetadata = new Metadata();
        this.fileCommandDetector.detect((InputStream)tis, tmpMetadata);
        return tmpMetadata.get("Content-Type");
    }

    private void checkForStrings() {
        String stringsProg = this.getStringsPath() + StringsParser.getStringsProg();
        String[] checkCmd = new String[]{stringsProg, "--version"};
        try {
            this.stringsPresent = ExternalParser.check((String[])checkCmd, (int[])new int[0]);
            if (!this.stringsPresent) {
                return;
            }
            if (!SystemUtils.IS_OS_WINDOWS) {
                String[] checkOpt = new String[]{stringsProg, "-e", "" + this.defaultStringsConfig.getEncoding().get(), "/dev/null"};
                int[] errorValues = new int[]{1, 2};
                this.hasEncodingOption = ExternalParser.check((String[])checkOpt, (int[])errorValues);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private int doStrings(File input, StringsConfig config, XHTMLContentHandler xhtml) throws IOException, TikaException, SAXException {
        String stringsProg = this.getStringsPath() + StringsParser.getStringsProg();
        ArrayList<Object> cmdList = new ArrayList<Object>(4);
        cmdList.add(stringsProg);
        cmdList.add("-n");
        cmdList.add("" + config.getMinLength());
        if (this.hasEncodingOption) {
            cmdList.add("-e");
            cmdList.add("" + config.getEncoding().get());
        }
        cmdList.add(input.getPath());
        String[] cmd = cmdList.toArray(new String[0]);
        ProcessBuilder pb = new ProcessBuilder(cmd);
        Process process = pb.start();
        InputStream out = process.getInputStream();
        AtomicInteger totalBytes = new AtomicInteger();
        Thread gobbler = this.logStream(out, (ContentHandler)xhtml, totalBytes);
        gobbler.start();
        try {
            boolean completed = process.waitFor(config.getTimeoutSeconds(), TimeUnit.SECONDS);
            if (!completed) {
                throw new TimeoutException("timed out");
            }
            gobbler.join(10000L);
        }
        catch (InterruptedException | TimeoutException e) {
            throw new TikaException("strings process failed", (Throwable)e);
        }
        finally {
            process.destroyForcibly();
        }
        return totalBytes.get();
    }

    private Thread logStream(InputStream stream, ContentHandler handler, AtomicInteger totalBytes) {
        return new Thread(() -> {
            InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
            char[] buffer = new char[1024];
            try {
                int n = reader.read(buffer);
                while (n != -1) {
                    handler.characters(buffer, 0, n);
                    totalBytes.addAndGet(n);
                    n = reader.read(buffer);
                }
            }
            catch (IOException | SAXException exception) {
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        });
    }

    public String getStringsPath() {
        return this.stringsPath;
    }

    @Field
    public void setStringsPath(String path) {
        if (!((String)path).isEmpty() && !((String)path).endsWith(File.separator)) {
            path = (String)path + File.separatorChar;
        }
        this.stringsPath = path;
    }

    @Field
    public void setEncoding(String encoding) {
        this.defaultStringsConfig.setEncoding(StringsEncoding.valueOf(encoding));
    }

    public int getMinLength() {
        return this.defaultStringsConfig.getMinLength();
    }

    @Field
    public void setMinLength(int minLength) {
        this.defaultStringsConfig.setMinLength(minLength);
    }

    public int getTimeoutSeconds() {
        return this.defaultStringsConfig.getTimeoutSeconds();
    }

    @Field
    public void setTimeoutSeconds(int timeoutSeconds) {
        this.defaultStringsConfig.setTimeoutSeconds(timeoutSeconds);
    }

    public StringsEncoding getStringsEncoding() {
        return this.defaultStringsConfig.getEncoding();
    }

    public void initialize(Map<String, Param> params) throws TikaConfigException {
        this.checkForStrings();
        this.fileCommandDetector = new FileCommandDetector();
        this.fileCommandDetector.setFilePath(this.filePath);
        this.fileCommandDetector.setTimeoutMs((long)(this.defaultStringsConfig.getTimeoutSeconds() * 1000));
    }

    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
    }
}

