/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.scan;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.UriUtil;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.file.Matcher;
import org.apache.tomcat.util.res.StringManager;

public class StandardJarScanner
implements JarScanner {
    private final Log log = LogFactory.getLog(StandardJarScanner.class);
    private static final Set<String> defaultJarsToSkip = new HashSet<String>();
    private static final StringManager sm = StringManager.getManager("org.apache.tomcat.util.scan");
    private boolean scanClassPath = true;
    private boolean scanAllFiles = false;
    private boolean scanAllDirectories = false;
    private boolean scanBootstrapClassPath = false;

    public boolean isScanClassPath() {
        return this.scanClassPath;
    }

    public void setScanClassPath(boolean scanClassPath) {
        this.scanClassPath = scanClassPath;
    }

    public boolean isScanAllFiles() {
        return this.scanAllFiles;
    }

    public void setScanAllFiles(boolean scanAllFiles) {
        this.scanAllFiles = scanAllFiles;
    }

    public boolean isScanAllDirectories() {
        return this.scanAllDirectories;
    }

    public void setScanAllDirectories(boolean scanAllDirectories) {
        this.scanAllDirectories = scanAllDirectories;
    }

    public boolean isScanBootstrapClassPath() {
        return this.scanBootstrapClassPath;
    }

    public void setScanBootstrapClassPath(boolean scanBootstrapClassPath) {
        this.scanBootstrapClassPath = scanBootstrapClassPath;
    }

    public void scan(ServletContext context, ClassLoader classloader, JarScannerCallback callback, Set<String> jarsToSkip) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)sm.getString("jarScan.webinflibStart"));
        }
        Set<String> ignoredJars = jarsToSkip == null ? defaultJarsToSkip : jarsToSkip;
        Set dirList = context.getResourcePaths("/WEB-INF/lib/");
        if (dirList != null) {
            for (String path : dirList) {
                if (path.endsWith(".jar") && !Matcher.matchName(ignoredJars, path.substring(path.lastIndexOf(47) + 1))) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)sm.getString("jarScan.webinflibJarScan", path));
                    }
                    URL url = null;
                    try {
                        String realPath = context.getRealPath(path);
                        url = realPath == null ? context.getResource(path) : new File(realPath).toURI().toURL();
                        this.process(callback, url);
                    }
                    catch (IOException e) {
                        this.log.warn((Object)sm.getString("jarScan.webinflibFail", url), (Throwable)e);
                    }
                    continue;
                }
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace((Object)sm.getString("jarScan.webinflibJarNoScan", path));
            }
        }
        if (this.scanClassPath && classloader != null) {
            this.doScanClassPath(classloader, callback, ignoredJars);
        }
    }

    protected void doScanClassPath(ClassLoader classloader, JarScannerCallback callback, Set<String> ignoredJars) {
        URL[] urls;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)sm.getString("jarScan.classloaderStart"));
        }
        ClassLoader loader = classloader;
        ClassLoader stopLoader = null;
        if (!this.scanBootstrapClassPath) {
            stopLoader = ClassLoader.getSystemClassLoader().getParent();
        }
        HashSet<URL> processedURLs = new HashSet<URL>();
        while (loader != null && loader != stopLoader) {
            if (loader instanceof URLClassLoader) {
                urls = ((URLClassLoader)loader).getURLs();
                for (int i = 0; i < urls.length; ++i) {
                    String jarName = this.getJarName(urls[i]);
                    if (jarName != null && !Matcher.matchName(ignoredJars, jarName) && !urls[i].toString().contains("/WEB-INF/lib/" + jarName)) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)sm.getString("jarScan.classloaderJarScan", urls[i]));
                        }
                        try {
                            this.process(callback, urls[i]);
                            processedURLs.add(urls[i]);
                        }
                        catch (IOException ioe) {
                            this.log.warn((Object)sm.getString("jarScan.classloaderFail", urls[i]), (Throwable)ioe);
                        }
                        continue;
                    }
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace((Object)sm.getString("jarScan.classloaderJarNoScan", urls[i]));
                }
            }
            loader = loader.getParent();
        }
        if (JreCompat.isJre9Available()) {
            urls = this.getClassPath();
            LinkedList modulePathUrls = new LinkedList();
            JreCompat.getInstance().addBootModulePath(modulePathUrls);
            urls.addAll(modulePathUrls);
            for (URL url : urls) {
                if (processedURLs.contains(url)) continue;
                try {
                    this.process(callback, url);
                    processedURLs.add(url);
                }
                catch (IOException ioe) {
                    this.log.warn((Object)sm.getString("jarScan.classloaderFail", url), (Throwable)ioe);
                }
            }
        }
    }

    protected List<URL> getClassPath() {
        String classPath = System.getProperty("java.class.path");
        if (classPath == null || classPath.length() == 0) {
            return Collections.emptyList();
        }
        String[] classPathEntries = classPath.split(File.pathSeparator);
        ArrayList<URL> urls = new ArrayList<URL>(classPathEntries.length);
        for (String classPathEntry : classPathEntries) {
            File f = new File(classPathEntry);
            try {
                urls.add(f.toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.log.warn((Object)sm.getString("jarScan.classPath.badEntry", classPathEntry), (Throwable)e);
            }
        }
        return urls;
    }

    protected void process(JarScannerCallback callback, URL url) throws IOException {
        URLConnection conn;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)sm.getString("jarScan.jarUrlStart", url));
        }
        if ((conn = url.openConnection()) instanceof JarURLConnection) {
            callback.scan((JarURLConnection)conn);
        } else {
            String urlStr = url.toString();
            if (urlStr.startsWith("file:") || urlStr.startsWith("jndi:") || urlStr.startsWith("http:") || urlStr.startsWith("https:")) {
                if (urlStr.endsWith(".jar")) {
                    URL jarURL = UriUtil.buildJarUrl((String)urlStr);
                    callback.scan((JarURLConnection)jarURL.openConnection());
                } else {
                    try {
                        File metainf;
                        File f = new File(url.toURI());
                        if (f.isFile() && this.scanAllFiles) {
                            URL jarURL = UriUtil.buildJarUrl((File)f);
                            callback.scan((JarURLConnection)jarURL.openConnection());
                        } else if (f.isDirectory() && this.scanAllDirectories && (metainf = new File(f.getAbsoluteFile() + File.separator + "META-INF")).isDirectory()) {
                            callback.scan(f);
                        }
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable((Throwable)t);
                        IOException ioe = new IOException();
                        ioe.initCause(t);
                        throw ioe;
                    }
                }
            }
        }
    }

    private String getJarName(URL url) {
        String name = null;
        String path = url.getPath();
        int end = path.indexOf(".jar");
        if (end != -1) {
            int start = path.lastIndexOf(47, end);
            name = path.substring(start + 1, end + 4);
        } else if (this.isScanAllDirectories()) {
            int start = path.lastIndexOf(47);
            name = path.substring(start + 1);
        }
        return name;
    }

    static {
        String jarList = System.getProperty("tomcat.util.scan.DefaultJarScanner.jarsToSkip");
        if (jarList != null) {
            StringTokenizer tokenizer = new StringTokenizer(jarList, ",");
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken().trim();
                if (token.length() <= 0) continue;
                defaultJarsToSkip.add(token);
            }
        }
    }
}

