/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.annotation.ElementValue;
import org.aspectj.apache.bcel.generic.ObjectType;

public class EnumElementValue
extends ElementValue {
    private int typeIdx;
    private int valueIdx;

    protected EnumElementValue(int n, int n2, ConstantPool constantPool) {
        super(101, constantPool);
        if (this.type != 101) {
            throw new RuntimeException("Only element values of type enum can be built with this ctor");
        }
        this.typeIdx = n;
        this.valueIdx = n2;
    }

    public EnumElementValue(ObjectType objectType, String string, ConstantPool constantPool) {
        super(101, constantPool);
        this.typeIdx = constantPool.addUtf8(objectType.getSignature());
        this.valueIdx = constantPool.addUtf8(string);
    }

    public EnumElementValue(EnumElementValue enumElementValue, ConstantPool constantPool, boolean bl) {
        super(101, constantPool);
        if (bl) {
            this.typeIdx = constantPool.addUtf8(enumElementValue.getEnumTypeString());
            this.valueIdx = constantPool.addUtf8(enumElementValue.getEnumValueString());
        } else {
            this.typeIdx = enumElementValue.getTypeIndex();
            this.valueIdx = enumElementValue.getValueIndex();
        }
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.type);
        dataOutputStream.writeShort(this.typeIdx);
        dataOutputStream.writeShort(this.valueIdx);
    }

    @Override
    public String stringifyValue() {
        StringBuffer stringBuffer = new StringBuffer();
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.cpool.getConstant(this.typeIdx, (byte)1);
        stringBuffer.append(constantUtf8.getValue());
        constantUtf8 = (ConstantUtf8)this.cpool.getConstant(this.valueIdx, (byte)1);
        stringBuffer.append(constantUtf8.getValue());
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("E(");
        stringBuilder.append(this.getEnumTypeString()).append(" ").append(this.getEnumValueString()).append(")");
        return stringBuilder.toString();
    }

    public String getEnumTypeString() {
        return ((ConstantUtf8)this.getConstantPool().getConstant(this.typeIdx)).getValue();
    }

    public String getEnumValueString() {
        return ((ConstantUtf8)this.getConstantPool().getConstant(this.valueIdx)).getValue();
    }

    public int getValueIndex() {
        return this.valueIdx;
    }

    public int getTypeIndex() {
        return this.typeIdx;
    }
}

