/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api;

import java.util.List;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.api.AbstractAssertWithOriginWithColumnsAndRowsFromChange;
import org.assertj.db.api.ChangeAssert;
import org.assertj.db.api.ChangeColumnAssert;
import org.assertj.db.api.ChangeRowValueAssert;
import org.assertj.db.api.ChangesAssert;
import org.assertj.db.api.assertions.AssertOnNumberOfColumns;
import org.assertj.db.api.assertions.AssertOnRowEquality;
import org.assertj.db.api.assertions.AssertOnRowOfChangeExistence;
import org.assertj.db.api.assertions.impl.AssertionsOnNumberOfColumns;
import org.assertj.db.api.assertions.impl.AssertionsOnRowEquality;
import org.assertj.db.api.assertions.impl.AssertionsOnRowOfChangeExistence;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.navigation.PositionWithColumns;
import org.assertj.db.navigation.element.RowElement;
import org.assertj.db.navigation.origin.OriginWithValuesFromRow;
import org.assertj.db.type.Row;
import org.assertj.db.type.Value;
import org.assertj.db.util.Descriptions;

public class ChangeRowAssert
extends AbstractAssertWithOriginWithColumnsAndRowsFromChange<ChangeRowAssert, ChangeAssert>
implements RowElement,
OriginWithValuesFromRow<ChangesAssert, ChangeAssert, ChangeColumnAssert, ChangeRowAssert, ChangeRowValueAssert>,
AssertOnRowEquality<ChangeRowAssert>,
AssertOnNumberOfColumns<ChangeRowAssert>,
AssertOnRowOfChangeExistence<ChangeRowAssert> {
    private final PositionWithColumns<ChangeRowAssert, ChangeRowValueAssert, Value> valuePosition;
    private final Row row;

    public ChangeRowAssert(ChangeAssert origin, Row row) {
        super(ChangeRowAssert.class, origin);
        this.row = row;
        this.valuePosition = new PositionWithColumns<ChangeRowAssert, ChangeRowValueAssert, Value>(this, ChangeRowValueAssert.class){

            @Override
            protected String getDescription(int index) {
                List<String> columnsNameList = ChangeRowAssert.this.row.getColumnsNameList();
                String columnName = columnsNameList.get(index);
                return Descriptions.getRowValueDescription(ChangeRowAssert.this.info, index, columnName);
            }
        };
    }

    @Override
    public ChangeRowValueAssert value() {
        if (this.row == null) {
            throw new AssertJDBException("Row do not exist", new Object[0]);
        }
        return (ChangeRowValueAssert)this.valuePosition.getInstance(this.row.getValuesList());
    }

    @Override
    public ChangeRowValueAssert value(int index) {
        if (this.row == null) {
            throw new AssertJDBException("Row do not exist", new Object[0]);
        }
        return (ChangeRowValueAssert)this.valuePosition.getInstance(this.row.getValuesList(), index);
    }

    @Override
    public ChangeRowValueAssert value(String columnName) {
        if (this.row == null) {
            throw new AssertJDBException("Row do not exist", new Object[0]);
        }
        return this.valuePosition.getInstance(this.row.getValuesList(), this.row.getColumnsNameList(), columnName, this.row.getColumnLetterCase());
    }

    @Override
    public ChangeRowAssert hasNumberOfColumns(int expected) {
        this.exists();
        List<String> columnsNameList = this.row.getColumnsNameList();
        int size = columnsNameList.size();
        return (ChangeRowAssert)AssertionsOnNumberOfColumns.hasNumberOfColumns((AbstractAssert)this.myself, this.info, size, expected);
    }

    @Override
    public ChangeRowAssert hasNumberOfColumnsGreaterThan(int expected) {
        this.exists();
        List<String> columnsNameList = this.row.getColumnsNameList();
        int size = columnsNameList.size();
        return (ChangeRowAssert)AssertionsOnNumberOfColumns.hasNumberOfColumnsGreaterThan((AbstractAssert)this.myself, this.info, size, expected);
    }

    @Override
    public ChangeRowAssert hasNumberOfColumnsLessThan(int expected) {
        this.exists();
        List<String> columnsNameList = this.row.getColumnsNameList();
        int size = columnsNameList.size();
        return (ChangeRowAssert)AssertionsOnNumberOfColumns.hasNumberOfColumnsLessThan((AbstractAssert)this.myself, this.info, size, expected);
    }

    @Override
    public ChangeRowAssert hasNumberOfColumnsGreaterThanOrEqualTo(int expected) {
        this.exists();
        List<String> columnsNameList = this.row.getColumnsNameList();
        int size = columnsNameList.size();
        return (ChangeRowAssert)AssertionsOnNumberOfColumns.hasNumberOfColumnsGreaterThanOrEqualTo((AbstractAssert)this.myself, this.info, size, expected);
    }

    @Override
    public ChangeRowAssert hasNumberOfColumnsLessThanOrEqualTo(int expected) {
        this.exists();
        List<String> columnsNameList = this.row.getColumnsNameList();
        int size = columnsNameList.size();
        return (ChangeRowAssert)AssertionsOnNumberOfColumns.hasNumberOfColumnsLessThanOrEqualTo((AbstractAssert)this.myself, this.info, size, expected);
    }

    @Override
    public ChangeRowAssert hasValues(Object ... expected) {
        this.exists();
        return (ChangeRowAssert)AssertionsOnRowEquality.hasValues((AbstractAssert)this.myself, this.info, this.row.getValuesList(), expected);
    }

    @Override
    public ChangeRowAssert exists() {
        return (ChangeRowAssert)AssertionsOnRowOfChangeExistence.exists((AbstractAssert)this.myself, this.info, this.row);
    }

    @Override
    public ChangeRowAssert doesNotExist() {
        return (ChangeRowAssert)AssertionsOnRowOfChangeExistence.doesNotExist((AbstractAssert)this.myself, this.info, this.row);
    }

    public ChangeAssert returnToChange() {
        return (ChangeAssert)this.returnToOrigin();
    }
}

