/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import java.util.List;
import java.util.UUID;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.api.assertions.impl.AssertionsOnColumnType;
import org.assertj.db.api.assertions.impl.AssertionsOnNumberOfRows;
import org.assertj.db.api.assertions.impl.AssertionsOnValueClass;
import org.assertj.db.error.ShouldBeEqual;
import org.assertj.db.type.DateTimeValue;
import org.assertj.db.type.DateValue;
import org.assertj.db.type.TimeValue;
import org.assertj.db.type.Value;
import org.assertj.db.type.ValueType;
import org.assertj.db.util.Values;

public class AssertionsOnColumnEquality {
    private static final Failures failures = Failures.instance();

    private AssertionsOnColumnEquality() {
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, List<Value> valuesList, Object ... expected) {
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        int index = 0;
        for (Value value : valuesList) {
            if (value.getValue() != null && expected[index] != null) {
                AssertionsOnValueClass.isOfClass(assertion, info, value, expected[index].getClass());
            }
            if (!Values.areEqual(value, expected[index])) {
                throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(index, value.getValue(), expected[index]));
            }
            ++index;
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, List<Value> valuesList, Boolean ... expected) {
        AssertionsOnColumnType.isBoolean(assertion, info, valuesList, true);
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        int index = 0;
        for (Value value : valuesList) {
            if (!Values.areEqual(value, expected[index])) {
                throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(index, value.getValue(), expected[index]));
            }
            ++index;
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, List<Value> valuesList, Number ... expected) {
        AssertionsOnColumnType.isNumber(assertion, info, valuesList, true);
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        int index = 0;
        for (Value value : valuesList) {
            if (!Values.areEqual(value, expected[index])) {
                throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(index, Values.getRepresentationFromValueInFrontOfExpected(value, expected[index]), expected[index]));
            }
            ++index;
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, List<Value> valuesList, byte[] ... expected) {
        AssertionsOnColumnType.isBytes(assertion, info, valuesList, true);
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        int index = 0;
        for (Value value : valuesList) {
            if (!Values.areEqual(value, expected[index])) {
                throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(index));
            }
            ++index;
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, List<Value> valuesList, String ... expected) {
        AssertionsOnColumnType.isOfAnyTypeIn(assertion, info, valuesList, ValueType.TEXT, ValueType.NUMBER, ValueType.DATE, ValueType.TIME, ValueType.DATE_TIME, ValueType.UUID, ValueType.NOT_IDENTIFIED);
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        int index = 0;
        for (Value value : valuesList) {
            if (!Values.areEqual(value, expected[index])) {
                throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(index, Values.getRepresentationFromValueInFrontOfExpected(value, expected[index]), expected[index]));
            }
            ++index;
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, List<Value> valuesList, Character ... expected) {
        AssertionsOnColumnType.isText(assertion, info, valuesList, true);
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        int index = 0;
        for (Value value : valuesList) {
            if (!Values.areEqual(value, expected[index])) {
                throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(index, value.getValue(), expected[index]));
            }
            ++index;
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, List<Value> valuesList, UUID ... expected) {
        AssertionsOnColumnType.isOfAnyTypeIn(assertion, info, valuesList, ValueType.UUID, ValueType.NOT_IDENTIFIED);
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        int index = 0;
        for (Value value : valuesList) {
            if (!Values.areEqual(value, expected[index])) {
                throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(index, Values.getRepresentationFromValueInFrontOfExpected(value, expected[index]), expected[index]));
            }
            ++index;
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, List<Value> valuesList, DateValue ... expected) {
        AssertionsOnColumnType.isOfAnyTypeIn(assertion, info, valuesList, ValueType.DATE, ValueType.DATE_TIME, ValueType.NOT_IDENTIFIED);
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        int index = 0;
        for (Value value : valuesList) {
            if (!Values.areEqual(value, expected[index])) {
                throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(index, Values.getRepresentationFromValueInFrontOfExpected(value, expected[index]), expected[index]));
            }
            ++index;
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, List<Value> valuesList, TimeValue ... expected) {
        AssertionsOnColumnType.isOfAnyTypeIn(assertion, info, valuesList, ValueType.TIME, ValueType.NOT_IDENTIFIED);
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        int index = 0;
        for (Value value : valuesList) {
            if (!Values.areEqual(value, expected[index])) {
                throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(index, Values.getRepresentationFromValueInFrontOfExpected(value, expected[index]), expected[index]));
            }
            ++index;
        }
        return assertion;
    }

    public static <A extends AbstractAssert<?>> A hasValues(A assertion, WritableAssertionInfo info, List<Value> valuesList, DateTimeValue ... expected) {
        AssertionsOnColumnType.isOfAnyTypeIn(assertion, info, valuesList, ValueType.DATE, ValueType.DATE_TIME, ValueType.NOT_IDENTIFIED);
        AssertionsOnNumberOfRows.hasNumberOfRows(assertion, info, valuesList.size(), expected.length);
        int index = 0;
        for (Value value : valuesList) {
            if (!Values.areEqual(value, expected[index])) {
                throw failures.failure((AssertionInfo)info, ShouldBeEqual.shouldBeEqual(index, Values.getRepresentationFromValueInFrontOfExpected(value, expected[index]), expected[index]));
            }
            ++index;
        }
        return assertion;
    }
}

