/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.api.assertions.impl;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.UUID;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.WritableAssertionInfo;
import org.assertj.core.internal.Failures;
import org.assertj.db.api.AbstractAssert;
import org.assertj.db.api.assertions.impl.AssertionsOnValueClass;
import org.assertj.db.api.assertions.impl.AssertionsOnValueType;
import org.assertj.db.error.ShouldNotBeEqual;
import org.assertj.db.type.DateTimeValue;
import org.assertj.db.type.DateValue;
import org.assertj.db.type.TimeValue;
import org.assertj.db.type.Value;
import org.assertj.db.type.ValueType;
import org.assertj.db.util.Values;

public class AssertionsOnValueInequality {
    private static final Failures failures = Failures.instance();

    private AssertionsOnValueInequality() {
    }

    public static <A extends AbstractAssert<?>> A isNotEqualTo(A assertion, WritableAssertionInfo info, Value value, Object expected) {
        if (value.getValue() != null && expected != null) {
            AssertionsOnValueClass.isOfClass(assertion, info, value, expected.getClass());
        }
        if (!Values.areEqual(value, expected)) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldNotBeEqual.shouldNotBeEqual(value.getValue(), expected));
    }

    public static <A extends AbstractAssert<?>> A isNotEqualTo(A assertion, WritableAssertionInfo info, Value value, Boolean expected) {
        if (expected != null) {
            AssertionsOnValueType.isBoolean(assertion, info, value);
        }
        if (!Values.areEqual(value, expected)) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldNotBeEqual.shouldNotBeEqual(value.getValue(), expected));
    }

    public static <A extends AbstractAssert<?>> A isNotEqualTo(A assertion, WritableAssertionInfo info, Value value, byte[] expected) {
        if (expected != null) {
            AssertionsOnValueType.isBytes(assertion, info, value);
        }
        if (!Values.areEqual(value, expected)) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldNotBeEqual.shouldNotBeEqual());
    }

    public static <A extends AbstractAssert<?>> A isNotEqualTo(A assertion, WritableAssertionInfo info, Value value, DateTimeValue expected) {
        if (expected != null) {
            AssertionsOnValueType.isOfAnyTypeIn(assertion, info, value, ValueType.DATE, ValueType.DATE_TIME);
        }
        if (!Values.areEqual(value, expected)) {
            return assertion;
        }
        Object object = value.getValue();
        if (value.getValueType() == ValueType.DATE) {
            throw failures.failure((AssertionInfo)info, ShouldNotBeEqual.shouldNotBeEqual(DateTimeValue.of(DateValue.from((Date)object)), expected));
        }
        if (object != null) {
            throw failures.failure((AssertionInfo)info, ShouldNotBeEqual.shouldNotBeEqual(DateTimeValue.from((Timestamp)object), expected));
        }
        throw failures.failure((AssertionInfo)info, ShouldNotBeEqual.shouldNotBeEqual(null, null));
    }

    public static <A extends AbstractAssert<?>> A isNotEqualTo(A assertion, WritableAssertionInfo info, Value value, DateValue expected) {
        if (expected != null) {
            AssertionsOnValueType.isOfAnyTypeIn(assertion, info, value, ValueType.DATE, ValueType.DATE_TIME);
        }
        if (!Values.areEqual(value, expected)) {
            return assertion;
        }
        Object object = value.getValue();
        if (value.getValueType() == ValueType.DATE) {
            throw failures.failure((AssertionInfo)info, ShouldNotBeEqual.shouldNotBeEqual(DateValue.from((Date)object), expected));
        }
        if (object != null) {
            throw failures.failure((AssertionInfo)info, ShouldNotBeEqual.shouldNotBeEqual(DateTimeValue.from((Timestamp)object), DateTimeValue.of(expected)));
        }
        throw failures.failure((AssertionInfo)info, ShouldNotBeEqual.shouldNotBeEqual(null, expected));
    }

    public static <A extends AbstractAssert<?>> A isNotEqualTo(A assertion, WritableAssertionInfo info, Value value, Number expected) {
        if (expected != null) {
            AssertionsOnValueType.isNumber(assertion, info, value);
        }
        if (!Values.areEqual(value, expected)) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldNotBeEqual.shouldNotBeEqual(value.getValue(), expected));
    }

    public static <A extends AbstractAssert<?>> A isNotEqualTo(A assertion, WritableAssertionInfo info, Value value, String expected) {
        if (expected != null) {
            AssertionsOnValueType.isOfAnyTypeIn(assertion, info, value, ValueType.TEXT, ValueType.NUMBER, ValueType.DATE, ValueType.TIME, ValueType.DATE_TIME, ValueType.UUID);
        }
        if (!Values.areEqual(value, expected)) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldNotBeEqual.shouldNotBeEqual(Values.getRepresentationFromValueInFrontOfExpected(value, expected), expected));
    }

    public static <A extends AbstractAssert<?>> A isNotEqualTo(A assertion, WritableAssertionInfo info, Value value, Character expected) {
        if (expected != null) {
            AssertionsOnValueType.isText(assertion, info, value);
        }
        if (!Values.areEqual(value, expected)) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldNotBeEqual.shouldNotBeEqual(Values.getRepresentationFromValueInFrontOfExpected(value, expected), expected));
    }

    public static <A extends AbstractAssert<?>> A isNotEqualTo(A assertion, WritableAssertionInfo info, Value value, UUID expected) {
        if (expected != null) {
            AssertionsOnValueType.isUUID(assertion, info, value);
        }
        if (!Values.areEqual(value, expected)) {
            return assertion;
        }
        throw failures.failure((AssertionInfo)info, ShouldNotBeEqual.shouldNotBeEqual(Values.getRepresentationFromValueInFrontOfExpected(value, expected), expected));
    }

    public static <A extends AbstractAssert<?>> A isNotEqualTo(A assertion, WritableAssertionInfo info, Value value, TimeValue expected) {
        if (expected != null) {
            AssertionsOnValueType.isTime(assertion, info, value);
        }
        if (!Values.areEqual(value, expected)) {
            return assertion;
        }
        Object object = value.getValue();
        if (object != null) {
            throw failures.failure((AssertionInfo)info, ShouldNotBeEqual.shouldNotBeEqual(TimeValue.from((Time)object), expected));
        }
        throw failures.failure((AssertionInfo)info, ShouldNotBeEqual.shouldNotBeEqual(null, null));
    }

    public static <A extends AbstractAssert<?>> A isNotZero(A assertion, WritableAssertionInfo info, Value value) {
        return AssertionsOnValueInequality.isNotEqualTo(assertion, info, value, 0);
    }
}

