/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type;

import java.sql.Date;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.Calendar;
import org.assertj.db.type.DateTimeValue;
import org.assertj.db.type.DateValueContainer;
import org.assertj.db.type.TimeValue;

public class DateValue
implements Comparable<DateValue>,
DateValueContainer {
    public static final String DATE_SHOULD_BE_NOT_NULL = "date should be not null";
    private final int dayOfTheMonth;
    private final int month;
    private final int year;
    private static final String DATE_FORMAT = "\\d\\d\\d\\d-\\d\\d-\\d\\d";

    public static DateValue of(int year, int month, int dayOfTheMonth) {
        return new DateValue(year, month, dayOfTheMonth);
    }

    public static DateValue parse(String date) throws ParseException {
        return new DateValue(date);
    }

    public static DateValue from(Date date) {
        return new DateValue(date);
    }

    public static DateValue from(Calendar calendar) {
        return new DateValue(calendar);
    }

    public static DateValue from(LocalDate localDate) {
        return new DateValue(localDate);
    }

    public static DateValue now() {
        return DateValue.from(Calendar.getInstance());
    }

    public DateValue(int year, int month, int dayOfTheMonth) {
        this.dayOfTheMonth = dayOfTheMonth;
        this.month = month;
        this.year = year;
    }

    public DateValue(String date) throws ParseException {
        if (date == null) {
            throw new NullPointerException(DATE_SHOULD_BE_NOT_NULL);
        }
        if (!date.matches(DATE_FORMAT)) {
            throw new ParseException("date must respect yyyy-mm-dd format", date.length());
        }
        this.year = Integer.parseInt(date.substring(0, 4));
        this.month = Integer.parseInt(date.substring(5, 7));
        this.dayOfTheMonth = Integer.parseInt(date.substring(8));
    }

    public DateValue(Date date) {
        if (date == null) {
            throw new NullPointerException(DATE_SHOULD_BE_NOT_NULL);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        this.dayOfTheMonth = calendar.get(5);
        this.month = calendar.get(2) + 1;
        this.year = calendar.get(1);
    }

    public DateValue(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException(DATE_SHOULD_BE_NOT_NULL);
        }
        this.dayOfTheMonth = calendar.get(5);
        this.month = calendar.get(2) + 1;
        this.year = calendar.get(1);
    }

    public DateValue(LocalDate localDate) {
        if (localDate == null) {
            throw new NullPointerException(DATE_SHOULD_BE_NOT_NULL);
        }
        this.dayOfTheMonth = localDate.getDayOfMonth();
        this.month = localDate.getMonthValue();
        this.year = localDate.getYear();
    }

    @Override
    public DateValue getDate() {
        return this;
    }

    @Override
    public boolean isMidnight() {
        return true;
    }

    public int getDayOfTheMonth() {
        return this.dayOfTheMonth;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public String toString() {
        return String.format("%4d-%02d-%02d", this.year, this.month, this.dayOfTheMonth);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DateValue) {
            DateValue dateValue = (DateValue)obj;
            return this.year == dateValue.year && this.month == dateValue.month && this.dayOfTheMonth == dateValue.dayOfTheMonth;
        }
        if (obj instanceof DateValueContainer) {
            DateValueContainer value = (DateValueContainer)obj;
            return this.equals(value.getDate()) && value.isMidnight();
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dayOfTheMonth;
        result = 31 * result + this.month;
        result = 31 * result + this.year;
        return result;
    }

    @Override
    public int compareTo(DateValue other) {
        if (this.year < other.year) {
            return -1;
        }
        if (this.year > other.year) {
            return 1;
        }
        if (this.month < other.month) {
            return -1;
        }
        if (this.month > other.month) {
            return 1;
        }
        if (this.dayOfTheMonth < other.dayOfTheMonth) {
            return -1;
        }
        if (this.dayOfTheMonth > other.dayOfTheMonth) {
            return 1;
        }
        return 0;
    }

    public boolean isBefore(DateValue date) {
        return this.compareTo(date) < 0;
    }

    public boolean isAfter(DateValue date) {
        return this.compareTo(date) > 0;
    }

    public DateValue move(DateValue date) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, this.year);
        calendar.set(2, this.month - 1);
        calendar.set(5, this.dayOfTheMonth);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        if (date.getYear() != 0) {
            calendar.add(1, date.getYear());
        }
        if (date.getMonth() != 0) {
            calendar.add(2, date.getMonth());
        }
        if (date.getDayOfTheMonth() != 0) {
            calendar.add(5, date.getDayOfTheMonth());
        }
        return DateValue.from(calendar);
    }

    public DateTimeValue move(TimeValue time) {
        TimeValue timeValue = TimeValue.of(0, 0);
        TimeValue movedTimeValue = timeValue.move(time);
        int hours = movedTimeValue.getHours();
        int days = hours / 24;
        hours = hours > 0 ? (hours -= days * 24) : (hours += days * 24);
        if (hours < 0) {
            --days;
            hours += 24;
        }
        DateValue dateValue = this.getDate();
        DateValue movedDateValue = dateValue.move(DateValue.of(0, 0, days));
        return DateTimeValue.of(movedDateValue, TimeValue.of(hours, movedTimeValue.getMinutes(), movedTimeValue.getSeconds(), movedTimeValue.getNanoSeconds()));
    }

    public DateTimeValue move(DateTimeValue dateTime) {
        DateValue date = this.move(dateTime.getDate());
        return date.move(dateTime.getTime());
    }

    public DateValue reverse() {
        return DateValue.of(-this.getYear(), -this.getMonth(), -this.getDayOfTheMonth());
    }
}

