/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.type.lettercase;

import java.util.HashMap;
import java.util.Map;
import org.assertj.db.type.lettercase.CaseComparison;
import org.assertj.db.type.lettercase.CaseComparisons;
import org.assertj.db.type.lettercase.CaseConversion;
import org.assertj.db.type.lettercase.CaseConversions;

public class LetterCase
implements CaseConversion,
CaseComparison {
    public static final LetterCase TABLE_DEFAULT = LetterCase.getLetterCase(CaseConversions.NO, CaseComparisons.IGNORE);
    public static final LetterCase COLUMN_DEFAULT = LetterCase.getLetterCase(CaseConversions.UPPER, CaseComparisons.IGNORE);
    public static final LetterCase PRIMARY_KEY_DEFAULT = LetterCase.getLetterCase(CaseConversions.UPPER, CaseComparisons.IGNORE);
    private final CaseConversion conversion;
    private final CaseComparison comparison;
    private static Map<CaseConversion, Map<CaseComparison, LetterCase>> cache;

    public static synchronized LetterCase getLetterCase(CaseConversion conversion, CaseComparison comparison) {
        Map<CaseComparison, LetterCase> map;
        if (conversion == null) {
            throw new NullPointerException("The case conversion must be not null");
        }
        if (comparison == null) {
            throw new NullPointerException("The case comparison must be not null");
        }
        if (cache == null) {
            cache = new HashMap<CaseConversion, Map<CaseComparison, LetterCase>>();
        }
        if ((map = cache.get(conversion)) == null) {
            map = new HashMap<CaseComparison, LetterCase>();
            cache.put(conversion, map);
            LetterCase letterCase = new LetterCase(conversion, comparison);
            map.put(comparison, letterCase);
            return letterCase;
        }
        LetterCase letterCase = map.get(comparison);
        if (letterCase == null) {
            letterCase = new LetterCase(conversion, comparison);
            map.put(comparison, letterCase);
        }
        return letterCase;
    }

    private LetterCase(CaseConversion conversion, CaseComparison comparison) {
        this.conversion = conversion;
        this.comparison = comparison;
    }

    @Override
    public String getComparisonName() {
        return this.comparison.getComparisonName();
    }

    @Override
    public boolean isEqual(String value1, String value2) {
        return this.comparison.isEqual(value1, value2);
    }

    @Override
    public int compare(String value1, String value2) {
        return this.comparison.compare(value1, value2);
    }

    @Override
    public String getConversionName() {
        return this.conversion.getConversionName();
    }

    @Override
    public String convert(String value) {
        return this.conversion.convert(value);
    }
}

