/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.type.DateTimeValue;
import org.assertj.db.type.DateValue;
import org.assertj.db.type.TimeValue;
import org.assertj.db.type.Value;
import org.assertj.db.type.ValueType;

public class Values {
    private Values() {
    }

    public static boolean areEqual(Value value, Object expected) {
        ValueType valueType = value.getValueType();
        if (valueType == ValueType.BOOLEAN) {
            if (expected instanceof Boolean) {
                return Values.areEqual(value, (Boolean)expected);
            }
        } else if (valueType == ValueType.NUMBER) {
            if (expected instanceof Number) {
                return Values.areEqual(value, (Number)expected);
            }
            if (expected instanceof String) {
                return Values.areEqual(value, (String)expected);
            }
        } else if (valueType == ValueType.BYTES) {
            if (expected instanceof byte[]) {
                return Values.areEqual(value, (byte[])expected);
            }
        } else if (valueType == ValueType.TEXT) {
            if (expected instanceof String) {
                return Values.areEqual(value, (String)expected);
            }
            if (expected instanceof Character) {
                return Values.areEqual(value, (Character)expected);
            }
        } else if (valueType == ValueType.UUID) {
            if (expected instanceof UUID) {
                return Values.areEqual(value, (UUID)expected);
            }
            if (expected instanceof String) {
                return Values.areEqual(value, (String)expected);
            }
        } else if (valueType == ValueType.DATE) {
            if (expected instanceof DateValue) {
                return Values.areEqual(value, (DateValue)expected);
            }
            if (expected instanceof String) {
                return Values.areEqual(value, (String)expected);
            }
            if (expected instanceof Date) {
                return Values.areEqual(value, DateValue.from((Date)expected));
            }
            if (expected instanceof LocalDate) {
                return Values.areEqual(value, DateValue.from((LocalDate)expected));
            }
        } else if (valueType == ValueType.TIME) {
            if (expected instanceof TimeValue) {
                return Values.areEqual(value, (TimeValue)expected);
            }
            if (expected instanceof String) {
                return Values.areEqual(value, (String)expected);
            }
            if (expected instanceof Time) {
                return Values.areEqual(value, TimeValue.from((Time)expected));
            }
            if (expected instanceof LocalTime) {
                return Values.areEqual(value, TimeValue.from((LocalTime)expected));
            }
        } else if (valueType == ValueType.DATE_TIME) {
            if (expected instanceof DateTimeValue) {
                return Values.areEqual(value, (DateTimeValue)expected);
            }
            if (expected instanceof DateValue) {
                return Values.areEqual(value, (DateValue)expected);
            }
            if (expected instanceof String) {
                return Values.areEqual(value, (String)expected);
            }
            if (expected instanceof Timestamp) {
                return Values.areEqual(value, DateTimeValue.from((Timestamp)expected));
            }
            if (expected instanceof LocalDateTime) {
                return Values.areEqual(value, DateTimeValue.from((LocalDateTime)expected));
            }
            if (expected instanceof LocalDate) {
                return Values.areEqual(value, DateValue.from((LocalDate)expected));
            }
        } else {
            Object object = value.getValue();
            if (expected == null && object == null) {
                return true;
            }
            if (object != null) {
                return object.equals(expected);
            }
        }
        return false;
    }

    public static boolean areEqual(Value value, Boolean expected) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        return expected.equals(object);
    }

    public static boolean areEqual(Value value, Number expected) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (expected instanceof BigInteger) {
            BigInteger bi;
            if (object instanceof BigInteger) {
                bi = (BigInteger)object;
            } else {
                try {
                    bi = new BigInteger("" + object);
                }
                catch (NumberFormatException e) {
                    throw new AssertJDBException("Expected <%s> can not be compared to a BigInteger (<%s>)", expected, object);
                }
            }
            return bi.compareTo((BigInteger)expected) == 0;
        }
        if (expected instanceof BigDecimal) {
            BigDecimal bd;
            if (object instanceof BigDecimal) {
                bd = (BigDecimal)object;
            } else {
                try {
                    bd = new BigDecimal("" + object);
                }
                catch (NumberFormatException e) {
                    throw new AssertJDBException("Expected <%s> can not be compared to a BigDecimal (<%s>)", expected, object);
                }
            }
            return bd.compareTo((BigDecimal)expected) == 0;
        }
        Long actualValue = null;
        if (object instanceof Float) {
            if (((Float)object).floatValue() == expected.floatValue()) {
                return true;
            }
        } else if (object instanceof Double) {
            if (((Double)object).doubleValue() == expected.doubleValue()) {
                return true;
            }
        } else if (object instanceof BigInteger) {
            BigInteger bi = new BigInteger("" + expected);
            if (((BigInteger)object).compareTo(bi) == 0) {
                return true;
            }
        } else if (object instanceof BigDecimal) {
            BigDecimal bd = new BigDecimal("" + expected);
            if (((BigDecimal)object).compareTo(bd) == 0) {
                return true;
            }
        } else if (object instanceof Byte) {
            actualValue = ((Byte)object).longValue();
        } else if (object instanceof Short) {
            actualValue = ((Short)object).longValue();
        } else if (object instanceof Integer) {
            actualValue = ((Integer)object).longValue();
        } else if (object instanceof Long) {
            actualValue = (Long)object;
        }
        if (actualValue != null) {
            if (expected instanceof Float) {
                return (float)actualValue.longValue() == expected.floatValue();
            }
            if (expected instanceof Double) {
                return (double)actualValue.longValue() == expected.doubleValue();
            }
            return actualValue.longValue() == expected.longValue();
        }
        return false;
    }

    public static boolean areEqual(Value value, byte[] expected) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            if (bytes.length != expected.length) {
                return false;
            }
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] == expected[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean areEqual(Date date, String expected) {
        try {
            DateTimeValue dateTimeValue = DateTimeValue.of(DateValue.from(date));
            DateTimeValue expectedDateTimeValue = DateTimeValue.parse(expected);
            if (dateTimeValue.equals(expectedDateTimeValue)) {
                return true;
            }
        }
        catch (ParseException e) {
            throw new AssertJDBException("Expected <%s> is not correct to compare to <%s>", expected, date);
        }
        return false;
    }

    private static boolean areEqual(Time time, String expected) {
        try {
            TimeValue timeValue = TimeValue.from(time);
            TimeValue expectedTimeValue = TimeValue.parse(expected);
            if (timeValue.equals(expectedTimeValue)) {
                return true;
            }
        }
        catch (ParseException e) {
            throw new AssertJDBException("Expected <%s> is not correct to compare to <%s>", expected, time);
        }
        return false;
    }

    private static boolean areEqual(Timestamp timestamp, String expected) {
        try {
            DateTimeValue dateTimeValue = DateTimeValue.from(timestamp);
            DateTimeValue expectedDateTimeValue = DateTimeValue.parse(expected);
            if (dateTimeValue.equals(expectedDateTimeValue)) {
                return true;
            }
        }
        catch (ParseException e) {
            throw new AssertJDBException("Expected <%s> is not correct to compare to <%s>", expected, timestamp);
        }
        return false;
    }

    private static boolean areEqual(Number number, String expected) {
        try {
            if (number instanceof Float) {
                if (number.floatValue() == Float.parseFloat(expected)) {
                    return true;
                }
            } else if (number instanceof Double) {
                if (number.doubleValue() == Double.parseDouble(expected)) {
                    return true;
                }
            } else if (number instanceof BigInteger) {
                BigInteger bi = new BigInteger("" + expected);
                if (((BigInteger)number).compareTo(bi) == 0) {
                    return true;
                }
            } else if (number instanceof BigDecimal) {
                BigDecimal bd = new BigDecimal("" + expected);
                if (((BigDecimal)number).compareTo(bd) == 0) {
                    return true;
                }
            } else {
                Long actual = null;
                if (number instanceof Byte || number instanceof Short || number instanceof Integer) {
                    actual = number.longValue();
                } else if (number instanceof Long) {
                    actual = (Long)number;
                }
                if (actual != null && actual == Long.parseLong(expected)) {
                    return true;
                }
            }
        }
        catch (NumberFormatException e) {
            throw new AssertJDBException("Expected <%s> is not correct to compare to <%s>", expected, number);
        }
        return false;
    }

    public static boolean areEqual(Value value, String expected) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (object instanceof Number) {
            return Values.areEqual((Number)object, expected);
        }
        if (object instanceof Date) {
            return Values.areEqual((Date)object, expected);
        }
        if (object instanceof Time) {
            return Values.areEqual((Time)object, expected);
        }
        if (object instanceof Timestamp) {
            return Values.areEqual((Timestamp)object, expected);
        }
        if (object instanceof UUID) {
            return Values.areEqual((UUID)object, expected);
        }
        return expected.equals(object);
    }

    public static boolean areEqual(Value value, Character expected) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (object instanceof String) {
            return ((String)object).charAt(0) == expected.charValue();
        }
        return expected.equals(object);
    }

    public static boolean areEqual(Value value, UUID expected) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        return expected.equals(object);
    }

    public static boolean areEqual(UUID value, String expected) {
        if (expected == null) {
            return value == null;
        }
        try {
            return UUID.fromString(expected).equals(value);
        }
        catch (IllegalArgumentException e) {
            throw new AssertJDBException("Expected <%s> is not correct to compare to <%s>", expected, value);
        }
    }

    public static boolean areEqual(Value value, DateValue expected) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            DateValue dateValue = DateValue.from(date);
            return dateValue.equals(expected);
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            DateTimeValue dateTimeValue = DateTimeValue.from(timestamp);
            return dateTimeValue.equals(DateTimeValue.of(expected));
        }
        return false;
    }

    public static boolean areEqual(Value value, TimeValue expected) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (object instanceof Time) {
            Time time = (Time)object;
            TimeValue timeValue = TimeValue.from(time);
            return timeValue.equals(expected);
        }
        return false;
    }

    public static boolean areEqual(Value value, DateTimeValue expected) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            DateTimeValue dateTimeValue = DateTimeValue.of(DateValue.from(date));
            return dateTimeValue.equals(expected);
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            DateTimeValue dateTimeValue = DateTimeValue.from(timestamp);
            return dateTimeValue.equals(expected);
        }
        return false;
    }

    public static int compare(Value value, Number expected) {
        Object object = value.getValue();
        if (expected instanceof BigInteger) {
            BigInteger bi;
            if (object instanceof BigInteger) {
                bi = (BigInteger)object;
            } else {
                try {
                    bi = new BigInteger("" + object);
                }
                catch (NumberFormatException e) {
                    throw new AssertJDBException("Expected <%s> can not be compared to a BigInteger (<%s>)", expected, object);
                }
            }
            return bi.compareTo((BigInteger)expected);
        }
        if (expected instanceof BigDecimal) {
            BigDecimal bd;
            if (object instanceof BigDecimal) {
                bd = (BigDecimal)object;
            } else {
                try {
                    bd = new BigDecimal("" + object);
                }
                catch (NumberFormatException e) {
                    throw new AssertJDBException("Expected <%s> can not be compared to a BigDecimal (<%s>)", expected, object);
                }
            }
            return bd.compareTo((BigDecimal)expected);
        }
        Long actualValue = null;
        if (object instanceof Float) {
            float f = ((Float)object).floatValue();
            float expectedF = expected.floatValue();
            return Float.compare(f, expectedF);
        }
        if (object instanceof Double) {
            double d = (Double)object;
            double expectedD = expected.doubleValue();
            return Double.compare(d, expectedD);
        }
        if (object instanceof BigInteger) {
            BigInteger bi = new BigInteger("" + expected);
            return ((BigInteger)object).compareTo(bi);
        }
        if (object instanceof BigDecimal) {
            BigDecimal bd = new BigDecimal("" + expected);
            return ((BigDecimal)object).compareTo(bd);
        }
        if (object instanceof Byte) {
            actualValue = ((Byte)object).longValue();
        } else if (object instanceof Short) {
            actualValue = ((Short)object).longValue();
        } else if (object instanceof Integer) {
            actualValue = ((Integer)object).longValue();
        } else if (object instanceof Long) {
            actualValue = (Long)object;
        }
        if (actualValue != null) {
            if (expected instanceof Float) {
                float expectedF = expected.floatValue();
                if ((float)actualValue.longValue() > expectedF) {
                    return 1;
                }
                if ((float)actualValue.longValue() < expectedF) {
                    return -1;
                }
                return 0;
            }
            if (expected instanceof Double) {
                double expectedD = expected.doubleValue();
                if ((double)actualValue.longValue() > expectedD) {
                    return 1;
                }
                if ((double)actualValue.longValue() < expectedD) {
                    return -1;
                }
                return 0;
            }
            double expectedL = expected.longValue();
            if ((double)actualValue.longValue() > expectedL) {
                return 1;
            }
            if ((double)actualValue.longValue() < expectedL) {
                return -1;
            }
            return 0;
        }
        throw new AssertJDBException("Expected <%s> can not be compared to a Number (<%s>)", expected, object);
    }

    public static Object[] getRepresentationsFromValuesInFrontOfExpected(Value[] values, Object[] expected) {
        Object[] representationsValues = new Object[values.length];
        int i = 0;
        for (Value obj : values) {
            representationsValues[i] = i >= expected.length ? obj.getValue() : Values.getRepresentationFromValueInFrontOfExpected(obj, expected[i]);
            ++i;
        }
        return representationsValues;
    }

    public static Object getRepresentationFromValueInFrontOfExpected(Value value, Object expected) {
        Object object = value.getValue();
        ValueType valueType = value.getValueType();
        if (valueType == ValueType.DATE && expected instanceof String) {
            if (((String)expected).contains("T")) {
                return DateTimeValue.of(DateValue.from((Date)object)).toString();
            }
            return DateValue.from((Date)object).toString();
        }
        return Values.getRepresentationFromValueInFrontOfClass(value, expected == null ? null : expected.getClass());
    }

    public static Object getRepresentationFromValueInFrontOfClass(Value value, Class<?> clazz) {
        Object object = value.getValue();
        ValueType valueType = value.getValueType();
        if (valueType == ValueType.DATE) {
            if (clazz == DateValue.class) {
                return DateValue.from((Date)object);
            }
            if (clazz == DateTimeValue.class) {
                return DateTimeValue.of(DateValue.from((Date)object));
            }
            if (clazz == String.class) {
                return DateTimeValue.of(DateValue.from((Date)object)).toString();
            }
            return object;
        }
        if (valueType == ValueType.TIME) {
            if (clazz == String.class) {
                return TimeValue.from((Time)object).toString();
            }
            return TimeValue.from((Time)object);
        }
        if (valueType == ValueType.DATE_TIME) {
            if (clazz == String.class) {
                return DateTimeValue.from((Timestamp)object).toString();
            }
            return DateTimeValue.from((Timestamp)object);
        }
        if (valueType == ValueType.NUMBER || valueType == ValueType.UUID) {
            if (clazz == String.class) {
                return object.toString();
            }
            return object;
        }
        return object;
    }

    private static boolean isObjectCloseToBigInteger(Object object, BigInteger expected, Number tolerance) {
        BigInteger bi;
        if (object instanceof BigInteger) {
            bi = (BigInteger)object;
        } else {
            try {
                bi = new BigInteger("" + object);
            }
            catch (NumberFormatException e) {
                throw new AssertJDBException("Expected <%s> can not be compared to a BigInteger (<%s>)", expected, object);
            }
        }
        BigInteger bigTolerance = new BigInteger("" + tolerance);
        BigInteger bigMin = expected.subtract(bigTolerance);
        BigInteger bigMax = expected.add(bigTolerance);
        return bi.compareTo(bigMin) >= 0 && bi.compareTo(bigMax) <= 0;
    }

    private static boolean isObjectCloseToBigDecimal(Object object, BigDecimal expected, Number tolerance) {
        BigDecimal bd;
        if (object instanceof BigDecimal) {
            bd = (BigDecimal)object;
        } else {
            try {
                bd = new BigDecimal("" + object);
            }
            catch (NumberFormatException e) {
                throw new AssertJDBException("Expected <%s> can not be compared to a BigDecimal (<%s>)", expected, object);
            }
        }
        BigDecimal bigTolerance = new BigDecimal("" + tolerance);
        BigDecimal bigMin = expected.subtract(bigTolerance);
        BigDecimal bigMax = expected.add(bigTolerance);
        return bd.compareTo(bigMin) >= 0 && bd.compareTo(bigMax) <= 0;
    }

    private static boolean isFloatCloseToNumber(Float nb, Number expected, Number tolerance) {
        float fMin = expected.floatValue() - tolerance.floatValue();
        float fMax = expected.floatValue() + tolerance.floatValue();
        return nb.floatValue() >= fMin && nb.floatValue() <= fMax;
    }

    private static boolean isDoubleCloseToNumber(Double nb, Number expected, Number tolerance) {
        double dMin = expected.doubleValue() - tolerance.doubleValue();
        double dMax = expected.doubleValue() + tolerance.doubleValue();
        return nb >= dMin && nb <= dMax;
    }

    private static boolean isBigIntegerCloseToNumber(BigInteger nb, Number expected, Number tolerance) {
        BigInteger bigExpected = new BigInteger("" + expected);
        BigInteger bigTolerance = new BigInteger("" + tolerance);
        BigInteger bigMin = bigExpected.subtract(bigTolerance);
        BigInteger bigMax = bigExpected.add(bigTolerance);
        return nb.compareTo(bigMin) >= 0 && nb.compareTo(bigMax) <= 0;
    }

    private static boolean isBigDecimalCloseToNumber(BigDecimal nb, Number expected, Number tolerance) {
        BigDecimal bigExpected = new BigDecimal("" + expected);
        BigDecimal bigTolerance = new BigDecimal("" + tolerance);
        BigDecimal bigMin = bigExpected.subtract(bigTolerance);
        BigDecimal bigMax = bigExpected.add(bigTolerance);
        return nb.compareTo(bigMin) >= 0 && nb.compareTo(bigMax) <= 0;
    }

    private static Long getLong(Object object) {
        if (object instanceof Byte) {
            return ((Byte)object).longValue();
        }
        if (object instanceof Short) {
            return ((Short)object).longValue();
        }
        if (object instanceof Integer) {
            return ((Integer)object).longValue();
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        return null;
    }

    private static boolean isLongCloseToFloat(Long nb, Float expected, Number tolerance) {
        if (tolerance instanceof Float) {
            return (float)nb.longValue() >= expected.floatValue() - tolerance.floatValue() && (float)nb.longValue() <= expected.floatValue() + tolerance.floatValue();
        }
        if (tolerance instanceof Double) {
            return (double)nb.longValue() >= (double)expected.floatValue() - tolerance.doubleValue() && (double)nb.longValue() <= (double)expected.floatValue() + tolerance.doubleValue();
        }
        return (float)nb.longValue() >= expected.floatValue() - (float)tolerance.longValue() && (float)nb.longValue() <= expected.floatValue() + (float)tolerance.longValue();
    }

    private static boolean isLongCloseToDouble(Long nb, Double expected, Number tolerance) {
        if (tolerance instanceof Float) {
            return (double)nb.longValue() >= expected - (double)tolerance.floatValue() && (double)nb.longValue() <= expected + (double)tolerance.floatValue();
        }
        if (tolerance instanceof Double) {
            return (double)nb.longValue() >= expected - tolerance.doubleValue() && (double)nb.longValue() <= expected + tolerance.doubleValue();
        }
        return (double)nb.longValue() >= expected - (double)tolerance.longValue() && (double)nb.longValue() <= expected + (double)tolerance.longValue();
    }

    private static boolean isLongCloseToNumber(Long nb, Number expected, Number tolerance) {
        if (tolerance instanceof Float) {
            return (float)nb.longValue() >= (float)expected.longValue() - tolerance.floatValue() && (float)nb.longValue() <= (float)expected.longValue() + tolerance.floatValue();
        }
        if (tolerance instanceof Double) {
            return (double)nb.longValue() >= (double)expected.longValue() - tolerance.doubleValue() && (double)nb.longValue() <= (double)expected.longValue() + tolerance.doubleValue();
        }
        return nb >= expected.longValue() - tolerance.longValue() && nb <= expected.longValue() + tolerance.longValue();
    }

    public static boolean areClose(Value value, Number expected, Number tolerance) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (expected instanceof BigInteger) {
            return Values.isObjectCloseToBigInteger(object, (BigInteger)expected, tolerance);
        }
        if (expected instanceof BigDecimal) {
            return Values.isObjectCloseToBigDecimal(object, (BigDecimal)expected, tolerance);
        }
        if (object instanceof Float) {
            return Values.isFloatCloseToNumber((Float)object, expected, tolerance);
        }
        if (object instanceof Double) {
            return Values.isDoubleCloseToNumber((Double)object, expected, tolerance);
        }
        if (object instanceof BigInteger) {
            return Values.isBigIntegerCloseToNumber((BigInteger)object, expected, tolerance);
        }
        if (object instanceof BigDecimal) {
            return Values.isBigDecimalCloseToNumber((BigDecimal)object, expected, tolerance);
        }
        Long actualValue = Values.getLong(object);
        if (actualValue != null) {
            if (expected instanceof Float) {
                return Values.isLongCloseToFloat(actualValue, Float.valueOf(expected.floatValue()), tolerance);
            }
            if (expected instanceof Double) {
                return Values.isLongCloseToDouble(actualValue, expected.doubleValue(), tolerance);
            }
            return Values.isLongCloseToNumber(actualValue, expected.longValue(), tolerance);
        }
        return false;
    }

    public static boolean areClose(Value value, DateValue expected, DateValue tolerance) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            DateValue dateValue = DateValue.from(date);
            DateValue dateValueMin = expected.move(tolerance.reverse());
            DateValue dateValueMax = expected.move(tolerance);
            return dateValue.compareTo(dateValueMin) >= 0 && dateValue.compareTo(dateValueMax) <= 0;
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            DateTimeValue dateTimeValue = DateTimeValue.from(timestamp);
            DateTimeValue dateTimeValueMin = DateTimeValue.of(expected).move(tolerance.reverse());
            DateTimeValue dateTimeValueMax = DateTimeValue.of(expected).move(tolerance);
            return dateTimeValue.compareTo(dateTimeValueMin) >= 0 && dateTimeValue.compareTo(dateTimeValueMax) <= 0;
        }
        return false;
    }

    public static boolean areClose(Value value, DateValue expected, TimeValue tolerance) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            DateTimeValue dateTimeValue = DateTimeValue.of(DateValue.from(date));
            DateTimeValue dateTimeValueMin = expected.move(tolerance.reverse());
            DateTimeValue dateTimeValueMax = expected.move(tolerance);
            return dateTimeValue.compareTo(dateTimeValueMin) >= 0 && dateTimeValue.compareTo(dateTimeValueMax) <= 0;
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            DateTimeValue dateTimeValue = DateTimeValue.from(timestamp);
            DateTimeValue dateTimeValueMin = DateTimeValue.of(expected).move(tolerance.reverse());
            DateTimeValue dateTimeValueMax = DateTimeValue.of(expected).move(tolerance);
            return dateTimeValue.compareTo(dateTimeValueMin) >= 0 && dateTimeValue.compareTo(dateTimeValueMax) <= 0;
        }
        return false;
    }

    public static boolean areClose(Value value, DateValue expected, DateTimeValue tolerance) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            DateTimeValue dateTimeValue = DateTimeValue.of(DateValue.from(date));
            DateTimeValue dateTimeValueMin = expected.move(tolerance.reverse());
            DateTimeValue dateTimeValueMax = expected.move(tolerance);
            return dateTimeValue.compareTo(dateTimeValueMin) >= 0 && dateTimeValue.compareTo(dateTimeValueMax) <= 0;
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            DateTimeValue dateTimeValue = DateTimeValue.from(timestamp);
            DateTimeValue dateTimeValueMin = DateTimeValue.of(expected).move(tolerance.reverse());
            DateTimeValue dateTimeValueMax = DateTimeValue.of(expected).move(tolerance);
            return dateTimeValue.compareTo(dateTimeValueMin) >= 0 && dateTimeValue.compareTo(dateTimeValueMax) <= 0;
        }
        return false;
    }

    public static boolean areClose(Value value, TimeValue expected, TimeValue tolerance) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (object instanceof Time) {
            Time time = (Time)object;
            TimeValue timeValue = TimeValue.from(time);
            TimeValue timeValueMin = expected.move(tolerance.reverse());
            TimeValue timeValueMax = expected.move(tolerance);
            return timeValue.compareTo(timeValueMin) >= 0 && timeValue.compareTo(timeValueMax) <= 0;
        }
        return false;
    }

    public static boolean areClose(Value value, DateTimeValue expected, DateValue tolerance) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            DateTimeValue dateTimeValue = DateTimeValue.of(DateValue.from(date));
            DateTimeValue dateTimeValueMin = expected.move(tolerance.reverse());
            DateTimeValue dateTimeValueMax = expected.move(tolerance);
            return dateTimeValue.compareTo(dateTimeValueMin) >= 0 && dateTimeValue.compareTo(dateTimeValueMax) <= 0;
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            DateTimeValue dateTimeValue = DateTimeValue.from(timestamp);
            DateTimeValue dateTimeValueMin = expected.move(tolerance.reverse());
            DateTimeValue dateTimeValueMax = expected.move(tolerance);
            return dateTimeValue.compareTo(dateTimeValueMin) >= 0 && dateTimeValue.compareTo(dateTimeValueMax) <= 0;
        }
        return false;
    }

    public static boolean areClose(Value value, DateTimeValue expected, TimeValue tolerance) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            DateTimeValue dateTimeValue = DateTimeValue.of(DateValue.from(date));
            DateTimeValue dateTimeValueMin = expected.move(tolerance.reverse());
            DateTimeValue dateTimeValueMax = expected.move(tolerance);
            return dateTimeValue.compareTo(dateTimeValueMin) >= 0 && dateTimeValue.compareTo(dateTimeValueMax) <= 0;
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            DateTimeValue dateTimeValue = DateTimeValue.from(timestamp);
            DateTimeValue dateTimeValueMin = expected.move(tolerance.reverse());
            DateTimeValue dateTimeValueMax = expected.move(tolerance);
            return dateTimeValue.compareTo(dateTimeValueMin) >= 0 && dateTimeValue.compareTo(dateTimeValueMax) <= 0;
        }
        return false;
    }

    public static boolean areClose(Value value, DateTimeValue expected, DateTimeValue tolerance) {
        Object object = value.getValue();
        if (expected == null) {
            return object == null;
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            DateTimeValue dateTimeValue = DateTimeValue.of(DateValue.from(date));
            DateTimeValue dateTimeValueMin = expected.move(tolerance.reverse());
            DateTimeValue dateTimeValueMax = expected.move(tolerance);
            return dateTimeValue.compareTo(dateTimeValueMin) >= 0 && dateTimeValue.compareTo(dateTimeValueMax) <= 0;
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            DateTimeValue dateTimeValue = DateTimeValue.from(timestamp);
            DateTimeValue dateTimeValueMin = expected.move(tolerance.reverse());
            DateTimeValue dateTimeValueMax = expected.move(tolerance);
            return dateTimeValue.compareTo(dateTimeValueMin) >= 0 && dateTimeValue.compareTo(dateTimeValueMax) <= 0;
        }
        return false;
    }
}

