/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.guava.api;

import com.google.common.collect.BoundType;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import java.util.ArrayList;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldContain;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.error.ShouldNotContain;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.guava.error.RangeShouldBeClosedInTheLowerBound;
import org.assertj.guava.error.RangeShouldBeClosedInTheUpperBound;
import org.assertj.guava.error.RangeShouldBeOpenedInTheLowerBound;
import org.assertj.guava.error.RangeShouldBeOpenedInTheUpperBound;
import org.assertj.guava.error.RangeShouldHaveLowerEndpointEqual;
import org.assertj.guava.error.RangeShouldHaveUpperEndpointEqual;
import org.assertj.guava.util.ExceptionUtils;

public class RangeAssert<T extends Comparable<T>>
extends AbstractAssert<RangeAssert<T>, Range<T>> {
    @VisibleForTesting
    Failures failures = Failures.instance();

    protected RangeAssert(Range<T> actual) {
        super(actual, RangeAssert.class);
    }

    public RangeAssert<T> contains(T ... values) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(values == null, "The values to look for should not be null", new Object[0]);
        if (values.length == 0 && ((Range)this.actual).isEmpty()) {
            return this;
        }
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(values.length == 0, "The values to look for should not be empty", new Object[0]);
        ArrayList valuesNotFound = Lists.newArrayList();
        for (T value : values) {
            if (((Range)this.actual).contains(value)) continue;
            valuesNotFound.add(value);
        }
        if (!valuesNotFound.isEmpty()) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldContain.shouldContain((Object)this.actual, values, (Object)valuesNotFound));
        }
        return this;
    }

    public RangeAssert<T> doesNotContain(T ... values) {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        ArrayList valuesFound = Lists.newArrayList();
        for (T value : values) {
            if (!((Range)this.actual).contains(value)) continue;
            valuesFound.add(value);
        }
        if (!valuesFound.isEmpty()) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldNotContain.shouldNotContain((Object)this.actual, values, (Object)valuesFound));
        }
        return this;
    }

    public RangeAssert<T> hasClosedLowerBound() throws AssertionError {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        if (((Range)this.actual).lowerBoundType() != BoundType.CLOSED) {
            throw this.failures.failure((AssertionInfo)this.info, RangeShouldBeClosedInTheLowerBound.shouldHaveClosedLowerBound((Range)this.actual));
        }
        return this;
    }

    public RangeAssert<T> hasClosedUpperBound() throws AssertionError {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        if (((Range)this.actual).upperBoundType() != BoundType.CLOSED) {
            throw this.failures.failure((AssertionInfo)this.info, RangeShouldBeClosedInTheUpperBound.shouldHaveClosedUpperBound((Range)this.actual));
        }
        return this;
    }

    public RangeAssert<T> hasLowerEndpointEqualTo(T value) throws AssertionError {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        if (!((Range)this.actual).lowerEndpoint().equals(value)) {
            throw this.failures.failure((AssertionInfo)this.info, RangeShouldHaveLowerEndpointEqual.shouldHaveEqualLowerEndpoint((Range)this.actual, value));
        }
        return this;
    }

    public RangeAssert<T> hasOpenedLowerBound() throws AssertionError {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        if (((Range)this.actual).lowerBoundType() != BoundType.OPEN) {
            throw this.failures.failure((AssertionInfo)this.info, RangeShouldBeOpenedInTheLowerBound.shouldHaveOpenedLowerBound((Range)this.actual));
        }
        return this;
    }

    public RangeAssert<T> hasOpenedUpperBound() throws AssertionError {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        if (((Range)this.actual).upperBoundType() != BoundType.OPEN) {
            throw this.failures.failure((AssertionInfo)this.info, RangeShouldBeOpenedInTheUpperBound.shouldHaveOpenedUpperBound((Range)this.actual));
        }
        return this;
    }

    public RangeAssert<T> hasUpperEndpointEqualTo(T value) throws AssertionError {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        if (!((Range)this.actual).upperEndpoint().equals(value)) {
            throw this.failures.failure((AssertionInfo)this.info, RangeShouldHaveUpperEndpointEqual.shouldHaveEqualUpperEndpoint((Range)this.actual, value));
        }
        return this;
    }

    public RangeAssert<T> isEmpty() throws AssertionError {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        if (!((Range)this.actual).isEmpty()) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldBeEmpty.shouldBeEmpty((Object)this.actual));
        }
        return this;
    }

    public RangeAssert<T> isNotEmpty() throws AssertionError {
        Objects.instance().assertNotNull((AssertionInfo)this.info, this.actual);
        if (((Range)this.actual).isEmpty()) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldNotBeEmpty.shouldNotBeEmpty());
        }
        return this;
    }
}

