/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.tracing;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanAttributesProvider;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.SpanScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingSpanFactory
implements SpanFactory {
    public static final LoggingSpanFactory INSTANCE = new LoggingSpanFactory();
    private static final Logger logger = LoggerFactory.getLogger(LoggingSpanFactory.class);

    private LoggingSpanFactory() {
    }

    @Override
    public Span createRootTrace(Supplier<String> operationNameSupplier) {
        return new Slf4jSpan(operationNameSupplier, () -> "Root trace started");
    }

    @Override
    public Span createHandlerSpan(Supplier<String> operationNameSupplier, Message<?> parentMessage, boolean isChildTrace, Message<?> ... linkedParents) {
        return new Slf4jSpan(operationNameSupplier, () -> String.format("Handler span started for message of type [%s] and identifier [%s]", parentMessage.getClass().getSimpleName(), parentMessage.getIdentifier()));
    }

    @Override
    public Span createDispatchSpan(Supplier<String> operationNameSupplier, Message<?> parentMessage, Message<?> ... linkedSiblings) {
        return new Slf4jSpan(operationNameSupplier, () -> this.getSpanMessage("Dispatch", parentMessage));
    }

    private String getSpanMessage(String spanType, Message<?> parentMessage) {
        return CurrentUnitOfWork.map(uow -> String.format("%s span started for message of type [%s] and identifier [%s] while handling message of type [%s] and identifier [%s]", spanType, parentMessage.getClass().getSimpleName(), parentMessage.getIdentifier(), uow.getMessage().getClass().getSimpleName(), uow.getMessage().getIdentifier())).orElseGet(() -> String.format("%s span started for message of type [%s] and identifier [%s]", spanType, parentMessage.getClass().getSimpleName(), parentMessage.getIdentifier()));
    }

    @Override
    public Span createInternalSpan(Supplier<String> operationNameSupplier) {
        return new Slf4jSpan(operationNameSupplier, () -> CurrentUnitOfWork.map(uow -> String.format("Internal span started while handling message of type [%s] and identifier [%s]", uow.getMessage().getClass().getSimpleName(), uow.getMessage().getIdentifier())).orElseGet(() -> "Internal span started"));
    }

    @Override
    public Span createInternalSpan(Supplier<String> operationNameSupplier, Message<?> message) {
        return new Slf4jSpan(operationNameSupplier, () -> this.getSpanMessage("Internal", message));
    }

    @Override
    public void registerSpanAttributeProvider(SpanAttributesProvider provider) {
    }

    @Override
    public <M extends Message<?>> M propagateContext(M message) {
        return message;
    }

    private static class Slf4jSpan
    implements Span {
        protected final String identifier;
        protected final String name;
        protected final Supplier<String> startLog;
        protected final List<Slf4jSpanScope> scopesList;

        private Slf4jSpan(Supplier<String> nameSupplier, Supplier<String> startLog) {
            this.startLog = startLog;
            this.identifier = IdentifierFactory.getInstance().generateIdentifier();
            this.name = nameSupplier.get();
            this.scopesList = new CopyOnWriteArrayList<Slf4jSpanScope>();
        }

        @Override
        public Span start() {
            logger.info("[{}][{}] {}", new Object[]{this.identifier, this.name, this.startLog.get()});
            return this;
        }

        @Override
        public SpanScope makeCurrent() {
            logger.debug("[{}][{}] Made current for thread [{}]", new Object[]{this.identifier, this.name, Thread.currentThread().getName()});
            Slf4jSpanScope scope = new Slf4jSpanScope();
            this.scopesList.add(scope);
            return scope;
        }

        @Override
        public void end() {
            if (!this.scopesList.isEmpty()) {
                logger.error("[{}][{}] Span ended without closing {} scopes!", new Object[]{this.identifier, this.name, this.scopesList.size()});
            }
            logger.info("[{}][{}] Span ended", (Object)this.identifier, (Object)this.name);
        }

        @Override
        public Span recordException(Throwable t) {
            logger.info("[{}][{}] Span recorded exception", new Object[]{this.identifier, this.name, t});
            return this;
        }

        @Override
        public Span addAttribute(String key, String value) {
            return this;
        }

        private class Slf4jSpanScope
        implements SpanScope {
            private Slf4jSpanScope() {
            }

            @Override
            public void close() {
                logger.debug("[{}][{}] Closed for thread [{}]", new Object[]{Slf4jSpan.this.identifier, Slf4jSpan.this.name, Thread.currentThread().getName()});
                Slf4jSpan.this.scopesList.remove(this);
            }
        }
    }
}

