/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.modelling.saga;

import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.axonframework.common.BuilderUtils;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.ListenerInvocationErrorHandler;
import org.axonframework.eventhandling.Segment;
import org.axonframework.messaging.annotation.HandlerDefinition;
import org.axonframework.messaging.annotation.ParameterResolverFactory;
import org.axonframework.modelling.saga.AbstractSagaManager;
import org.axonframework.modelling.saga.AssociationValue;
import org.axonframework.modelling.saga.SagaCreationPolicy;
import org.axonframework.modelling.saga.SagaInitializationPolicy;
import org.axonframework.modelling.saga.SagaManagerSpanFactory;
import org.axonframework.modelling.saga.SagaMethodMessageHandlingMember;
import org.axonframework.modelling.saga.SagaRepository;
import org.axonframework.modelling.saga.metamodel.AnnotationSagaMetaModelFactory;
import org.axonframework.modelling.saga.metamodel.SagaModel;
import org.axonframework.tracing.SpanFactory;

public class AnnotatedSagaManager<T>
extends AbstractSagaManager<T> {
    private final SagaModel<T> sagaMetaModel;

    protected AnnotatedSagaManager(Builder<T> builder) {
        super(builder);
        this.sagaMetaModel = builder.buildSagaModel();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public boolean canHandle(@Nonnull EventMessage<?> eventMessage, @Nonnull Segment segment) {
        return this.sagaMetaModel.hasHandlerMethod(eventMessage);
    }

    @Override
    protected SagaInitializationPolicy getSagaCreationPolicy(EventMessage<?> event) {
        return this.sagaMetaModel.findHandlerMethods(event).stream().map(h -> h.unwrap(SagaMethodMessageHandlingMember.class).orElse(null)).filter(Objects::nonNull).filter(sh -> sh.getCreationPolicy() != SagaCreationPolicy.NONE).map(sh -> new SagaInitializationPolicy(sh.getCreationPolicy(), sh.getAssociationValue(event))).findFirst().orElse(SagaInitializationPolicy.NONE);
    }

    @Override
    protected Set<AssociationValue> extractAssociationValues(EventMessage<?> event) {
        return this.sagaMetaModel.findHandlerMethods(event).stream().map(h -> h.unwrap(SagaMethodMessageHandlingMember.class).orElse(null)).filter(Objects::nonNull).map(h -> h.getAssociationValue(event)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static class Builder<T>
    extends AbstractSagaManager.Builder<T> {
        private ParameterResolverFactory parameterResolverFactory;
        private HandlerDefinition handlerDefinition;
        private SagaModel<T> sagaModel;

        @Override
        public Builder<T> sagaRepository(SagaRepository<T> sagaRepository) {
            super.sagaRepository(sagaRepository);
            return this;
        }

        @Override
        public Builder<T> sagaType(Class<T> sagaType) {
            super.sagaType(sagaType);
            return this;
        }

        @Override
        public Builder<T> sagaFactory(Supplier<T> sagaFactory) {
            super.sagaFactory(sagaFactory);
            return this;
        }

        @Override
        public Builder<T> listenerInvocationErrorHandler(ListenerInvocationErrorHandler listenerInvocationErrorHandler) {
            super.listenerInvocationErrorHandler(listenerInvocationErrorHandler);
            return this;
        }

        @Override
        @Deprecated
        public Builder<T> spanFactory(SpanFactory spanFactory) {
            super.spanFactory(spanFactory);
            return this;
        }

        @Override
        public Builder<T> spanFactory(SagaManagerSpanFactory spanFactory) {
            super.spanFactory(spanFactory);
            return this;
        }

        public Builder<T> parameterResolverFactory(ParameterResolverFactory parameterResolverFactory) {
            BuilderUtils.assertNonNull((Object)parameterResolverFactory, (String)"ParameterResolverFactory may not be null");
            this.parameterResolverFactory = parameterResolverFactory;
            return this;
        }

        public Builder<T> handlerDefinition(HandlerDefinition handlerDefinition) {
            BuilderUtils.assertNonNull((Object)handlerDefinition, (String)"HandlerDefinition may not be null");
            this.handlerDefinition = handlerDefinition;
            return this;
        }

        public Builder<T> sagaModel(SagaModel<T> sagaModel) {
            BuilderUtils.assertNonNull(sagaModel, (String)"SagaModel may not be null");
            this.sagaModel = sagaModel;
            return this;
        }

        public AnnotatedSagaManager<T> build() {
            return new AnnotatedSagaManager(this);
        }

        protected SagaModel<T> buildSagaModel() {
            if (this.sagaModel == null) {
                return this.inspectSagaModel();
            }
            return this.sagaModel;
        }

        private SagaModel<T> inspectSagaModel() {
            if (this.parameterResolverFactory == null && this.handlerDefinition == null) {
                return new AnnotationSagaMetaModelFactory().modelOf(this.sagaType);
            }
            if (this.parameterResolverFactory != null && this.handlerDefinition == null) {
                return new AnnotationSagaMetaModelFactory(this.parameterResolverFactory).modelOf(this.sagaType);
            }
            return new AnnotationSagaMetaModelFactory(this.parameterResolverFactory, this.handlerDefinition).modelOf(this.sagaType);
        }
    }
}

