/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.openpgp.operator.jcajce.SHA1PGPDigestCalculator;

public class JcePBEKeyEncryptionMethodGenerator
extends PBEKeyEncryptionMethodGenerator {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());

    public JcePBEKeyEncryptionMethodGenerator(char[] cArray, PGPDigestCalculator pGPDigestCalculator) {
        super(cArray, pGPDigestCalculator);
    }

    public JcePBEKeyEncryptionMethodGenerator(char[] cArray) {
        this(cArray, new SHA1PGPDigestCalculator());
    }

    public JcePBEKeyEncryptionMethodGenerator(char[] cArray, PGPDigestCalculator pGPDigestCalculator, int n) {
        super(cArray, pGPDigestCalculator, n);
    }

    public JcePBEKeyEncryptionMethodGenerator(char[] cArray, int n) {
        super(cArray, new SHA1PGPDigestCalculator(), n);
    }

    public JcePBEKeyEncryptionMethodGenerator setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcePBEKeyEncryptionMethodGenerator setProvider(String string) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(string));
        return this;
    }

    public PBEKeyEncryptionMethodGenerator setSecureRandom(SecureRandom secureRandom) {
        super.setSecureRandom(secureRandom);
        return this;
    }

    protected byte[] encryptSessionInfo(int n, byte[] byArray, byte[] byArray2) throws PGPException {
        try {
            String string = PGPUtil.getSymmetricCipherName(n);
            Cipher cipher = this.helper.createCipher(string + "/CFB/NoPadding");
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, PGPUtil.getSymmetricCipherName(n));
            cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(new byte[cipher.getBlockSize()]));
            return cipher.doFinal(byArray2, 0, byArray2.length);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new PGPException("illegal block size: " + illegalBlockSizeException.getMessage(), illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new PGPException("bad padding: " + badPaddingException.getMessage(), badPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new PGPException("IV invalid: " + invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("key invalid: " + invalidKeyException.getMessage(), invalidKeyException);
        }
    }

    protected byte[] generateV6KEK(int n, byte[] byArray, byte[] byArray2) throws PGPException {
        HKDFBytesGenerator hKDFBytesGenerator = new HKDFBytesGenerator((Digest)new SHA256Digest());
        hKDFBytesGenerator.init((DerivationParameters)new HKDFParameters(byArray, null, byArray2));
        int n2 = SymmetricKeyUtils.getKeyLengthInOctets(n);
        byte[] byArray3 = new byte[n2];
        hKDFBytesGenerator.generateBytes(byArray3, 0, byArray3.length);
        return byArray3;
    }

    protected byte[] getEskAndTag(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws PGPException {
        byte[] byArray5 = new byte[byArray.length - 3];
        System.arraycopy(byArray, 1, byArray5, 0, byArray5.length);
        AEADBlockCipher aEADBlockCipher = BcAEADUtil.createAEADCipher(n, n2);
        aEADBlockCipher.init(true, (CipherParameters)new AEADParameters(new KeyParameter(byArray2), 128, byArray3, byArray4));
        int n3 = aEADBlockCipher.getOutputSize(byArray5.length);
        byte[] byArray6 = new byte[n3];
        int n4 = aEADBlockCipher.processBytes(byArray5, 0, byArray5.length, byArray6, 0);
        try {
            n4 += aEADBlockCipher.doFinal(byArray6, n4);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new PGPException("cannot encrypt session info", (Exception)((Object)invalidCipherTextException));
        }
        return byArray6;
    }
}

