/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.async;

import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import org.bsc.async.AsyncGenerator;

class InternalIterator<E>
implements Iterator<E>,
AsyncGenerator.HasResultValue,
AsyncGenerator.IsCancellable {
    private final AsyncGenerator<E> delegate;
    private volatile AsyncGenerator.Data<E> currentFetchedData;

    public InternalIterator(AsyncGenerator<E> delegate) {
        this.delegate = delegate;
        this.currentFetchedData = delegate.next();
    }

    @Override
    public boolean hasNext() {
        if (this.isCancelled()) {
            return false;
        }
        AsyncGenerator.Data<E> value = this.currentFetchedData;
        return value != null && !value.isDone();
    }

    @Override
    public E next() {
        if (this.isCancelled()) {
            throw new CancellationException("generator is cancelled");
        }
        AsyncGenerator.Data<E> next = this.currentFetchedData;
        if (next == null || next.isDone()) {
            throw new IllegalStateException("no more elements into iterator");
        }
        if (!next.isError()) {
            this.currentFetchedData = this.delegate.next();
        }
        return next.future().join();
    }

    @Override
    public Optional<Object> resultValue() {
        AsyncGenerator<E> asyncGenerator = this.delegate;
        if (asyncGenerator instanceof AsyncGenerator.HasResultValue) {
            AsyncGenerator.HasResultValue withResult = (AsyncGenerator.HasResultValue)((Object)asyncGenerator);
            return withResult.resultValue();
        }
        return Optional.empty();
    }

    @Override
    public boolean isCancelled() {
        AsyncGenerator<E> asyncGenerator = this.delegate;
        if (asyncGenerator instanceof AsyncGenerator.IsCancellable) {
            AsyncGenerator.IsCancellable isCancellable = (AsyncGenerator.IsCancellable)((Object)asyncGenerator);
            return isCancellable.isCancelled();
        }
        return false;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        AsyncGenerator<E> asyncGenerator = this.delegate;
        if (asyncGenerator instanceof AsyncGenerator.IsCancellable) {
            AsyncGenerator.IsCancellable isCancellable = (AsyncGenerator.IsCancellable)((Object)asyncGenerator);
            return isCancellable.cancel(mayInterruptIfRunning);
        }
        return false;
    }
}

