/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.langgraph4j.langchain4j.serializer.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import dev.langchain4j.data.message.ChatMessage;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class GenericListDeserializer
extends StdDeserializer<List<Object>> {
    public GenericListDeserializer() {
        super(List.class);
    }

    public List<Object> deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
        ObjectMapper mapper = (ObjectMapper)p.getCodec();
        ArrayNode node = (ArrayNode)mapper.readTree(p);
        LinkedList<Object> result = new LinkedList<Object>();
        for (JsonNode valueNode : node) {
            Object value = valueNode.isObject() && valueNode.has("@type") ? mapper.treeToValue((TreeNode)valueNode, ChatMessage.class) : (valueNode.isInt() ? Integer.valueOf(valueNode.intValue()) : (valueNode.isTextual() ? valueNode.textValue() : mapper.treeToValue((TreeNode)valueNode, Object.class)));
            result.add(value);
        }
        return result;
    }
}

