/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.bytedeco.javacpp.indexer.FloatIndexer;

public class FloatBufferIndexer
extends FloatIndexer {
    protected FloatBuffer buffer;

    public FloatBufferIndexer(FloatBuffer buffer) {
        this(buffer, new long[]{buffer.limit()}, ONE_STRIDE);
    }

    public FloatBufferIndexer(FloatBuffer buffer, long ... sizes) {
        this(buffer, sizes, FloatBufferIndexer.strides(sizes));
    }

    public FloatBufferIndexer(FloatBuffer buffer, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.buffer = buffer;
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public float get(long i) {
        return this.buffer.get((int)i);
    }

    @Override
    public FloatIndexer get(long i, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            f[offset + n] = this.buffer.get((int)i * (int)this.strides[0] + n);
        }
        return this;
    }

    @Override
    public float get(long i, long j) {
        return this.buffer.get((int)i * (int)this.strides[0] + (int)j);
    }

    @Override
    public FloatIndexer get(long i, long j, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            f[offset + n] = this.buffer.get((int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n);
        }
        return this;
    }

    @Override
    public float get(long i, long j, long k) {
        return this.buffer.get((int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k);
    }

    @Override
    public float get(long ... indices) {
        return this.buffer.get((int)this.index(indices));
    }

    @Override
    public FloatIndexer get(long[] indices, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            f[offset + n] = this.buffer.get((int)this.index(indices) + n);
        }
        return this;
    }

    @Override
    public FloatIndexer put(long i, float f) {
        this.buffer.put((int)i, f);
        return this;
    }

    @Override
    public FloatIndexer put(long i, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put((int)i * (int)this.strides[0] + n, f[offset + n]);
        }
        return this;
    }

    @Override
    public FloatIndexer put(long i, long j, float f) {
        this.buffer.put((int)i * (int)this.strides[0] + (int)j, f);
        return this;
    }

    @Override
    public FloatIndexer put(long i, long j, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put((int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n, f[offset + n]);
        }
        return this;
    }

    @Override
    public FloatIndexer put(long i, long j, long k, float f) {
        this.buffer.put((int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k, f);
        return this;
    }

    @Override
    public FloatIndexer put(long[] indices, float f) {
        this.buffer.put((int)this.index(indices), f);
        return this;
    }

    @Override
    public FloatIndexer put(long[] indices, float[] f, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put((int)this.index(indices) + n, f[offset + n]);
        }
        return this;
    }

    @Override
    public void release() {
        this.buffer = null;
    }
}

