// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.leptonica;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.leptonica.global.leptonica.*;


/**
 * \file colorfill.h
 *
 * <pre>
 *  Contains the following struct
 *      struct L_Colorfill
 *
 *  This accumulates color information, linked to location, within a
 *  set of tiles that (mostly) covers an input RGB image.
 * </pre>
 */


/*------------------------------------------------------------------------*
 *                            Colorfill data                              *
 *------------------------------------------------------------------------*/
/** Colorfill data */
@Name("L_Colorfill") @Properties(inherit = org.bytedeco.leptonica.presets.leptonica.class)
public class L_COLORFILL extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public L_COLORFILL() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public L_COLORFILL(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public L_COLORFILL(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public L_COLORFILL position(long position) {
        return (L_COLORFILL)super.position(position);
    }
    @Override public L_COLORFILL getPointer(long i) {
        return new L_COLORFILL((Pointer)this).offsetAddress(i);
    }

    /** clone of source pix                    */
    public native PIX pixs(); public native L_COLORFILL pixs(PIX setter);
    /** source pix, after optional transform   */
    public native PIX pixst(); public native L_COLORFILL pixst(PIX setter);
    /** number of tiles in each tile row       */
    public native @Cast("l_int32") int nx(); public native L_COLORFILL nx(int setter);
    /** number of tiles in each tile column    */
    public native @Cast("l_int32") int ny(); public native L_COLORFILL ny(int setter);
    /** width of each tile                     */
    public native @Cast("l_int32") int tw(); public native L_COLORFILL tw(int setter);
    /** height of each tile                    */
    public native @Cast("l_int32") int th(); public native L_COLORFILL th(int setter);
    /** min number of pixels in a color region */
    public native @Cast("l_int32") int minarea(); public native L_COLORFILL minarea(int setter);
    /** tile locations                         */
    public native BOXA boxas(); public native L_COLORFILL boxas(BOXA setter);
    /** tiles from source pix                  */
    public native PIXA pixas(); public native L_COLORFILL pixas(PIXA setter);
    /** mask tiles with components covering    */
    /** regions with similar color             */
    public native PIXA pixam(); public native L_COLORFILL pixam(PIXA setter);
    /** sizes of color regions (in pixels)     */
    public native NUMAA naa(); public native L_COLORFILL naa(NUMAA setter);
    /** average color in each region           */
    public native L_DNAA dnaa(); public native L_COLORFILL dnaa(L_DNAA setter);
    /** debug reconstruction from segmentation */
    public native PIXA pixadb(); public native L_COLORFILL pixadb(PIXA setter);
}
