/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.SizeTPointer;
import org.bytedeco.javacpp.annotation.ByRef;
import org.bytedeco.javacpp.annotation.ByVal;
import org.bytedeco.javacpp.annotation.Cast;
import org.bytedeco.javacpp.annotation.Const;
import org.bytedeco.javacpp.annotation.MemberGetter;
import org.bytedeco.javacpp.annotation.Name;
import org.bytedeco.javacpp.annotation.Namespace;
import org.bytedeco.javacpp.annotation.NoException;
import org.bytedeco.javacpp.annotation.NoOffset;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.javacpp.annotation.StdVector;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.AbstractMat;
import org.bytedeco.opencv.opencv_core.CvArr;
import org.bytedeco.opencv.opencv_core.GpuMat;
import org.bytedeco.opencv.opencv_core.MatAllocator;
import org.bytedeco.opencv.opencv_core.MatExpr;
import org.bytedeco.opencv.opencv_core.Point;
import org.bytedeco.opencv.opencv_core.Point2d;
import org.bytedeco.opencv.opencv_core.Point2f;
import org.bytedeco.opencv.opencv_core.Point3d;
import org.bytedeco.opencv.opencv_core.Point3f;
import org.bytedeco.opencv.opencv_core.Point3i;
import org.bytedeco.opencv.opencv_core.Range;
import org.bytedeco.opencv.opencv_core.RangeVector;
import org.bytedeco.opencv.opencv_core.Rect;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.bytedeco.opencv.opencv_core.Scalar4i;
import org.bytedeco.opencv.opencv_core.Size;
import org.bytedeco.opencv.opencv_core.UMat;
import org.bytedeco.opencv.opencv_core.UMatData;

@Namespace(value="cv")
@NoOffset
@Properties(inherit={org.bytedeco.opencv.presets.opencv_core.class})
public class Mat
extends AbstractMat {
    private Pointer pointer;
    public static final int MAGIC_VAL = 1124007936;
    public static final int AUTO_STEP = 0;
    public static final int CONTINUOUS_FLAG = 16384;
    public static final int SUBMATRIX_FLAG = 32768;
    public static final int MAGIC_MASK = -65536;
    public static final int TYPE_MASK = 4095;
    public static final int DEPTH_MASK = 7;

    public Mat(Pointer p) {
        super(p);
    }

    public Mat(long size) {
        super(null);
        this.allocateArray(size);
    }

    private native void allocateArray(long var1);

    public Mat position(long position) {
        return (Mat)super.position(position);
    }

    public Mat getPointer(long i) {
        return (Mat)new Mat((Pointer)this).offsetAddress(i);
    }

    public Mat() {
        super(null);
        this.allocate();
    }

    @NoException
    private native void allocate();

    public Mat(int rows, int cols, int type) {
        super(null);
        this.allocate(rows, cols, type);
    }

    private native void allocate(int var1, int var2, int var3);

    public Mat(@ByVal Size size, int type) {
        super(null);
        this.allocate(size, type);
    }

    private native void allocate(@ByVal Size var1, int var2);

    public Mat(int rows, int cols, int type, @Const @ByRef Scalar s) {
        super(null);
        this.allocate(rows, cols, type, s);
    }

    private native void allocate(int var1, int var2, int var3, @Const @ByRef Scalar var4);

    public Mat(@ByVal Size size, int type, @Const @ByRef Scalar s) {
        super(null);
        this.allocate(size, type, s);
    }

    private native void allocate(@ByVal Size var1, int var2, @Const @ByRef Scalar var3);

    public Mat(int ndims, @Const IntPointer sizes, int type) {
        super(null);
        this.allocate(ndims, sizes, type);
    }

    private native void allocate(int var1, @Const IntPointer var2, int var3);

    public Mat(int ndims, @Const IntBuffer sizes, int type) {
        super(null);
        this.allocate(ndims, sizes, type);
    }

    private native void allocate(int var1, @Const IntBuffer var2, int var3);

    public Mat(int ndims, @Const int[] sizes, int type) {
        super(null);
        this.allocate(ndims, sizes, type);
    }

    private native void allocate(int var1, @Const int[] var2, int var3);

    public Mat(@StdVector IntPointer sizes, int type) {
        super(null);
        this.allocate(sizes, type);
    }

    private native void allocate(@StdVector IntPointer var1, int var2);

    public Mat(@StdVector IntBuffer sizes, int type) {
        super(null);
        this.allocate(sizes, type);
    }

    private native void allocate(@StdVector IntBuffer var1, int var2);

    public Mat(@StdVector int[] sizes, int type) {
        super(null);
        this.allocate(sizes, type);
    }

    private native void allocate(@StdVector int[] var1, int var2);

    public Mat(int ndims, @Const IntPointer sizes, int type, @Const @ByRef Scalar s) {
        super(null);
        this.allocate(ndims, sizes, type, s);
    }

    private native void allocate(int var1, @Const IntPointer var2, int var3, @Const @ByRef Scalar var4);

    public Mat(int ndims, @Const IntBuffer sizes, int type, @Const @ByRef Scalar s) {
        super(null);
        this.allocate(ndims, sizes, type, s);
    }

    private native void allocate(int var1, @Const IntBuffer var2, int var3, @Const @ByRef Scalar var4);

    public Mat(int ndims, @Const int[] sizes, int type, @Const @ByRef Scalar s) {
        super(null);
        this.allocate(ndims, sizes, type, s);
    }

    private native void allocate(int var1, @Const int[] var2, int var3, @Const @ByRef Scalar var4);

    public Mat(@StdVector IntPointer sizes, int type, @Const @ByRef Scalar s) {
        super(null);
        this.allocate(sizes, type, s);
    }

    private native void allocate(@StdVector IntPointer var1, int var2, @Const @ByRef Scalar var3);

    public Mat(@StdVector IntBuffer sizes, int type, @Const @ByRef Scalar s) {
        super(null);
        this.allocate(sizes, type, s);
    }

    private native void allocate(@StdVector IntBuffer var1, int var2, @Const @ByRef Scalar var3);

    public Mat(@StdVector int[] sizes, int type, @Const @ByRef Scalar s) {
        super(null);
        this.allocate(sizes, type, s);
    }

    private native void allocate(@StdVector int[] var1, int var2, @Const @ByRef Scalar var3);

    public Mat(@Const @ByRef Mat m) {
        super(null);
        this.allocate(m);
    }

    private native void allocate(@Const @ByRef Mat var1);

    public Mat(int rows, int cols, int type, Pointer data, @Cast(value={"size_t"}) long step) {
        super(null);
        this.allocate(rows, cols, type, data, step);
        this.pointer = data;
    }

    private native void allocate(int var1, int var2, int var3, Pointer var4, @Cast(value={"size_t"}) long var5);

    public Mat(int rows, int cols, int type, Pointer data) {
        this(rows, cols, type, data, 0L);
    }

    public Mat(CvArr arr) {
        super(opencv_core.cvarrToMat(arr));
        this.pointer = arr;
    }

    public Mat(int rows, int cols, int type, Pointer data, boolean copyData) {
        super(null);
        if (copyData) {
            this.allocate(rows, cols, type);
            this.data().put(data);
        } else {
            this.allocate(rows, cols, type, data, 0L);
            this.pointer = data;
        }
    }

    public Mat(int type, Pointer data, boolean copyData) {
        this((int)Math.min(data.limit() - data.position(), Integer.MAX_VALUE), 1, type, data, copyData);
    }

    public Mat(Point points, boolean copyData) {
        this(opencv_core.CV_32SC2, (Pointer)points, copyData);
    }

    public Mat(Point2f points, boolean copyData) {
        this(opencv_core.CV_32FC2, (Pointer)points, copyData);
    }

    public Mat(Point2d points, boolean copyData) {
        this(opencv_core.CV_64FC2, (Pointer)points, copyData);
    }

    public Mat(Point3i points, boolean copyData) {
        this(opencv_core.CV_32SC3, (Pointer)points, copyData);
    }

    public Mat(Point3f points, boolean copyData) {
        this(opencv_core.CV_32FC3, (Pointer)points, copyData);
    }

    public Mat(Point3d points, boolean copyData) {
        this(opencv_core.CV_64FC3, (Pointer)points, copyData);
    }

    public Mat(Scalar scalar, boolean copyData) {
        this(opencv_core.CV_64FC4, (Pointer)scalar, copyData);
    }

    public Mat(Scalar4i scalar, boolean copyData) {
        this(opencv_core.CV_32SC4, (Pointer)scalar, copyData);
    }

    public Mat(Point points) {
        this(points, false);
    }

    public Mat(Point2f points) {
        this(points, false);
    }

    public Mat(Point2d points) {
        this(points, false);
    }

    public Mat(Point3i points) {
        this(points, false);
    }

    public Mat(Point3f points) {
        this(points, false);
    }

    public Mat(Point3d points) {
        this(points, false);
    }

    public Mat(Scalar scalar) {
        this(scalar, false);
    }

    public Mat(Scalar4i scalar) {
        this(scalar, false);
    }

    public Mat(byte ... b) {
        this(b, false);
    }

    public Mat(short ... s) {
        this(s, false);
    }

    public Mat(byte[] b, boolean signed) {
        this(b.length, 1, signed ? opencv_core.CV_8SC1 : opencv_core.CV_8UC1);
        this.data().put(b);
    }

    public Mat(short[] s, boolean signed) {
        this(s.length, 1, signed ? opencv_core.CV_16SC1 : opencv_core.CV_16UC1);
        new ShortPointer((Pointer)this.data()).put(s);
    }

    public Mat(int ... n) {
        this(n.length, 1, opencv_core.CV_32SC1);
        new IntPointer((Pointer)this.data()).put(n);
    }

    public Mat(double ... d) {
        this(d.length, 1, opencv_core.CV_64FC1);
        new DoublePointer((Pointer)this.data()).put(d);
    }

    public Mat(float ... f) {
        this(f.length, 1, opencv_core.CV_32FC1);
        new FloatPointer((Pointer)this.data()).put(f);
    }

    public Mat(BytePointer p) {
        this(p, false);
    }

    public Mat(ShortPointer p) {
        this(p, false);
    }

    public Mat(BytePointer p, boolean signed) {
        this(p, signed, false);
    }

    public Mat(ShortPointer p, boolean signed) {
        this(p, signed, false);
    }

    public Mat(IntPointer p) {
        this(p, false);
    }

    public Mat(FloatPointer p) {
        this(p, false);
    }

    public Mat(DoublePointer p) {
        this(p, false);
    }

    public Mat(BytePointer p, boolean signed, boolean copyData) {
        this(signed ? opencv_core.CV_8SC1 : opencv_core.CV_8UC1, (Pointer)p, copyData);
    }

    public Mat(ShortPointer p, boolean signed, boolean copyData) {
        this(signed ? opencv_core.CV_16SC1 : opencv_core.CV_16UC1, (Pointer)p, copyData);
    }

    public Mat(IntPointer p, boolean copyData) {
        this(opencv_core.CV_32SC1, (Pointer)p, copyData);
    }

    public Mat(FloatPointer p, boolean copyData) {
        this(opencv_core.CV_32FC1, (Pointer)p, copyData);
    }

    public Mat(DoublePointer p, boolean copyData) {
        this(opencv_core.CV_64FC1, (Pointer)p, copyData);
    }

    public Mat(@ByVal Size size, int type, Pointer data, @Cast(value={"size_t"}) long step) {
        super(null);
        this.allocate(size, type, data, step);
    }

    private native void allocate(@ByVal Size var1, int var2, Pointer var3, @Cast(value={"size_t"}) long var4);

    public Mat(@ByVal Size size, int type, Pointer data) {
        super(null);
        this.allocate(size, type, data);
    }

    private native void allocate(@ByVal Size var1, int var2, Pointer var3);

    public Mat(int ndims, @Const IntPointer sizes, int type, Pointer data, @Cast(value={"const size_t*"}) SizeTPointer steps) {
        super(null);
        this.allocate(ndims, sizes, type, data, steps);
    }

    private native void allocate(int var1, @Const IntPointer var2, int var3, Pointer var4, @Cast(value={"const size_t*"}) SizeTPointer var5);

    public Mat(int ndims, @Const IntPointer sizes, int type, Pointer data) {
        super(null);
        this.allocate(ndims, sizes, type, data);
    }

    private native void allocate(int var1, @Const IntPointer var2, int var3, Pointer var4);

    public Mat(int ndims, @Const IntBuffer sizes, int type, Pointer data, @Cast(value={"const size_t*"}) SizeTPointer steps) {
        super(null);
        this.allocate(ndims, sizes, type, data, steps);
    }

    private native void allocate(int var1, @Const IntBuffer var2, int var3, Pointer var4, @Cast(value={"const size_t*"}) SizeTPointer var5);

    public Mat(int ndims, @Const IntBuffer sizes, int type, Pointer data) {
        super(null);
        this.allocate(ndims, sizes, type, data);
    }

    private native void allocate(int var1, @Const IntBuffer var2, int var3, Pointer var4);

    public Mat(int ndims, @Const int[] sizes, int type, Pointer data, @Cast(value={"const size_t*"}) SizeTPointer steps) {
        super(null);
        this.allocate(ndims, sizes, type, data, steps);
    }

    private native void allocate(int var1, @Const int[] var2, int var3, Pointer var4, @Cast(value={"const size_t*"}) SizeTPointer var5);

    public Mat(int ndims, @Const int[] sizes, int type, Pointer data) {
        super(null);
        this.allocate(ndims, sizes, type, data);
    }

    private native void allocate(int var1, @Const int[] var2, int var3, Pointer var4);

    public Mat(@StdVector IntPointer sizes, int type, Pointer data, @Cast(value={"const size_t*"}) SizeTPointer steps) {
        super(null);
        this.allocate(sizes, type, data, steps);
    }

    private native void allocate(@StdVector IntPointer var1, int var2, Pointer var3, @Cast(value={"const size_t*"}) SizeTPointer var4);

    public Mat(@StdVector IntPointer sizes, int type, Pointer data) {
        super(null);
        this.allocate(sizes, type, data);
    }

    private native void allocate(@StdVector IntPointer var1, int var2, Pointer var3);

    public Mat(@StdVector IntBuffer sizes, int type, Pointer data, @Cast(value={"const size_t*"}) SizeTPointer steps) {
        super(null);
        this.allocate(sizes, type, data, steps);
    }

    private native void allocate(@StdVector IntBuffer var1, int var2, Pointer var3, @Cast(value={"const size_t*"}) SizeTPointer var4);

    public Mat(@StdVector IntBuffer sizes, int type, Pointer data) {
        super(null);
        this.allocate(sizes, type, data);
    }

    private native void allocate(@StdVector IntBuffer var1, int var2, Pointer var3);

    public Mat(@StdVector int[] sizes, int type, Pointer data, @Cast(value={"const size_t*"}) SizeTPointer steps) {
        super(null);
        this.allocate(sizes, type, data, steps);
    }

    private native void allocate(@StdVector int[] var1, int var2, Pointer var3, @Cast(value={"const size_t*"}) SizeTPointer var4);

    public Mat(@StdVector int[] sizes, int type, Pointer data) {
        super(null);
        this.allocate(sizes, type, data);
    }

    private native void allocate(@StdVector int[] var1, int var2, Pointer var3);

    public Mat(@Const @ByRef Mat m, @Const @ByRef Range rowRange, @Const @ByRef(nullValue="cv::Range::all()") Range colRange) {
        super(null);
        this.allocate(m, rowRange, colRange);
    }

    private native void allocate(@Const @ByRef Mat var1, @Const @ByRef Range var2, @Const @ByRef(nullValue="cv::Range::all()") Range var3);

    public Mat(@Const @ByRef Mat m, @Const @ByRef Range rowRange) {
        super(null);
        this.allocate(m, rowRange);
    }

    private native void allocate(@Const @ByRef Mat var1, @Const @ByRef Range var2);

    public Mat(@Const @ByRef Mat m, @Const @ByRef Rect roi) {
        super(null);
        this.allocate(m, roi);
    }

    private native void allocate(@Const @ByRef Mat var1, @Const @ByRef Rect var2);

    public Mat(@Const @ByRef Mat m, @Const @ByRef RangeVector ranges) {
        super(null);
        this.allocate(m, ranges);
    }

    private native void allocate(@Const @ByRef Mat var1, @Const @ByRef RangeVector var2);

    public Mat(@Const @ByRef GpuMat m) {
        super(null);
        this.allocate(m);
    }

    private native void allocate(@Const @ByRef GpuMat var1);

    @ByRef
    @Name(value={"operator ="})
    public native Mat put(@Const @ByRef Mat var1);

    @ByRef
    @Name(value={"operator ="})
    public native Mat put(@Const @ByRef MatExpr var1);

    @ByVal
    public native UMat getUMat(@Cast(value={"cv::AccessFlag"}) int var1, @Cast(value={"cv::UMatUsageFlags"}) int var2);

    @ByVal
    public native UMat getUMat(@Cast(value={"cv::AccessFlag"}) int var1);

    @ByVal
    public native Mat row(int var1);

    @ByVal
    public native Mat col(int var1);

    @ByVal
    public native Mat rowRange(int var1, int var2);

    @ByVal
    public native Mat rowRange(@Const @ByRef Range var1);

    @ByVal
    public native Mat colRange(int var1, int var2);

    @ByVal
    public native Mat colRange(@Const @ByRef Range var1);

    @ByVal
    public native Mat diag(int var1);

    @ByVal
    public native Mat diag();

    @ByVal
    public static native Mat diag(@Const @ByRef Mat var0);

    @ByVal
    public native Mat clone();

    public native void copyTo(@ByVal Mat var1);

    public native void copyTo(@ByVal UMat var1);

    public native void copyTo(@ByVal GpuMat var1);

    public native void copyTo(@ByVal Mat var1, @ByVal Mat var2);

    public native void copyTo(@ByVal UMat var1, @ByVal UMat var2);

    public native void copyTo(@ByVal GpuMat var1, @ByVal GpuMat var2);

    public native void convertTo(@ByVal Mat var1, int var2, double var3, double var5);

    public native void convertTo(@ByVal Mat var1, int var2);

    public native void convertTo(@ByVal UMat var1, int var2, double var3, double var5);

    public native void convertTo(@ByVal UMat var1, int var2);

    public native void convertTo(@ByVal GpuMat var1, int var2, double var3, double var5);

    public native void convertTo(@ByVal GpuMat var1, int var2);

    public native void assignTo(@ByRef Mat var1, int var2);

    public native void assignTo(@ByRef Mat var1);

    @ByRef
    @Name(value={"operator ="})
    public native Mat put(@Const @ByRef Scalar var1);

    @ByRef
    public native Mat setTo(@ByVal Mat var1, @ByVal(nullValue="cv::InputArray(cv::noArray())") Mat var2);

    @ByRef
    public native Mat setTo(@ByVal Mat var1);

    @ByRef
    public native Mat setTo(@ByVal UMat var1, @ByVal(nullValue="cv::InputArray(cv::noArray())") UMat var2);

    @ByRef
    public native Mat setTo(@ByVal UMat var1);

    @ByRef
    public native Mat setTo(@ByVal GpuMat var1, @ByVal(nullValue="cv::InputArray(cv::noArray())") GpuMat var2);

    @ByRef
    public native Mat setTo(@ByVal GpuMat var1);

    @ByVal
    public native Mat reshape(int var1, int var2);

    @ByVal
    public native Mat reshape(int var1);

    @ByVal
    public native Mat reshape(int var1, int var2, @Const IntPointer var3);

    @ByVal
    public native Mat reshape(int var1, int var2, @Const IntBuffer var3);

    @ByVal
    public native Mat reshape(int var1, int var2, @Const int[] var3);

    @ByVal
    public native Mat reshape(int var1, @StdVector IntPointer var2);

    @ByVal
    public native Mat reshape(int var1, @StdVector IntBuffer var2);

    @ByVal
    public native Mat reshape(int var1, @StdVector int[] var2);

    @ByVal
    public native MatExpr t();

    @ByVal
    public native MatExpr inv(int var1);

    @ByVal
    public native MatExpr inv();

    @ByVal
    public native MatExpr mul(@ByVal Mat var1, double var2);

    @ByVal
    public native MatExpr mul(@ByVal Mat var1);

    @ByVal
    public native MatExpr mul(@ByVal UMat var1, double var2);

    @ByVal
    public native MatExpr mul(@ByVal UMat var1);

    @ByVal
    public native MatExpr mul(@ByVal GpuMat var1, double var2);

    @ByVal
    public native MatExpr mul(@ByVal GpuMat var1);

    @ByVal
    public native Mat cross(@ByVal Mat var1);

    @ByVal
    public native Mat cross(@ByVal UMat var1);

    @ByVal
    public native Mat cross(@ByVal GpuMat var1);

    public native double dot(@ByVal Mat var1);

    public native double dot(@ByVal UMat var1);

    public native double dot(@ByVal GpuMat var1);

    @ByVal
    public static native MatExpr zeros(int var0, int var1, int var2);

    @ByVal
    public static native MatExpr zeros(@ByVal Size var0, int var1);

    @ByVal
    public static native MatExpr ones(int var0, int var1, int var2);

    @ByVal
    public static native MatExpr ones(@ByVal Size var0, int var1);

    @ByVal
    public static native MatExpr eye(int var0, int var1, int var2);

    @ByVal
    public static native MatExpr eye(@ByVal Size var0, int var1);

    @Override
    public native void create(int var1, int var2, int var3);

    public native void create(@ByVal Size var1, int var2);

    public native void create(int var1, @Const IntPointer var2, int var3);

    public native void create(int var1, @Const IntBuffer var2, int var3);

    public native void create(int var1, @Const int[] var2, int var3);

    public native void create(@StdVector IntPointer var1, int var2);

    public native void create(@StdVector IntBuffer var1, int var2);

    public native void create(@StdVector int[] var1, int var2);

    public native void addref();

    @Override
    public native void release();

    @Name(value={"deallocate"})
    public native void _deallocate();

    public native void copySize(@Const @ByRef Mat var1);

    public native void reserve(@Cast(value={"size_t"}) long var1);

    public native void reserveBuffer(@Cast(value={"size_t"}) long var1);

    public native void resize(@Cast(value={"size_t"}) long var1);

    public native void resize(@Cast(value={"size_t"}) long var1, @Const @ByRef Scalar var3);

    public native void push_back_(@Const Pointer var1);

    public native void push_back(@Const @ByRef Mat var1);

    public native void pop_back(@Cast(value={"size_t"}) long var1);

    public native void pop_back();

    public native void locateROI(@ByRef Size var1, @ByRef Point var2);

    @ByRef
    public native Mat adjustROI(int var1, int var2, int var3, int var4);

    @ByVal
    @Name(value={"operator ()"})
    public native Mat apply(@ByVal Range var1, @ByVal Range var2);

    @ByVal
    @Name(value={"operator ()"})
    public native Mat apply(@Const @ByRef Rect var1);

    @ByVal
    @Name(value={"operator ()"})
    public native Mat apply(@Const Range var1);

    @ByVal
    @Name(value={"operator ()"})
    public native Mat apply(@Const @ByRef RangeVector var1);

    @Cast(value={"bool"})
    public native boolean isContinuous();

    @Cast(value={"bool"})
    public native boolean isSubmatrix();

    @Cast(value={"size_t"})
    public native long elemSize();

    @Override
    @Cast(value={"size_t"})
    public native long elemSize1();

    @Override
    public native int type();

    @Override
    public native int depth();

    @Override
    public native int channels();

    @Cast(value={"size_t"})
    public native long step1(int var1);

    @Cast(value={"size_t"})
    public native long step1();

    @Cast(value={"bool"})
    public native boolean empty();

    @Cast(value={"size_t"})
    public native long total();

    @Cast(value={"size_t"})
    public native long total(int var1, int var2);

    @Cast(value={"size_t"})
    public native long total(int var1);

    public native int checkVector(int var1, int var2, @Cast(value={"bool"}) boolean var3);

    public native int checkVector(int var1);

    @Cast(value={"uchar*"})
    public native BytePointer ptr(int var1);

    @Cast(value={"uchar*"})
    public native BytePointer ptr();

    @Cast(value={"uchar*"})
    public native BytePointer ptr(int var1, int var2);

    @Cast(value={"uchar*"})
    public native BytePointer ptr(int var1, int var2, int var3);

    @Cast(value={"uchar*"})
    public native BytePointer ptr(@Const IntPointer var1);

    @Cast(value={"uchar*"})
    public native ByteBuffer ptr(@Const IntBuffer var1);

    @Cast(value={"uchar*"})
    public native byte[] ptr(@Const int[] var1);

    public native int flags();

    public native Mat flags(int var1);

    @Override
    public native int dims();

    public native Mat dims(int var1);

    @Override
    public native int rows();

    public native Mat rows(int var1);

    @Override
    public native int cols();

    public native Mat cols(int var1);

    @Override
    @Cast(value={"uchar*"})
    public native BytePointer data();

    public native Mat data(BytePointer var1);

    @Cast(value={"const uchar*"})
    public native BytePointer datastart();

    public native Mat datastart(BytePointer var1);

    @Cast(value={"const uchar*"})
    public native BytePointer dataend();

    public native Mat dataend(BytePointer var1);

    @Cast(value={"const uchar*"})
    public native BytePointer datalimit();

    public native Mat datalimit(BytePointer var1);

    public native MatAllocator allocator();

    public native Mat allocator(MatAllocator var1);

    public static native MatAllocator getStdAllocator();

    public static native MatAllocator getDefaultAllocator();

    public static native void setDefaultAllocator(MatAllocator var0);

    public native void updateContinuityFlag();

    public native UMatData u();

    public native Mat u(UMatData var1);

    @ByVal
    public native Size size();

    @Override
    @MemberGetter
    public native int size(int var1);

    @MemberGetter
    public native long step();

    @Override
    @MemberGetter
    public native long step(int var1);

    static {
        Loader.load();
    }
}

