/*
 * Decompiled with CFR 0.152.
 */
package org.casbin.adapter;

import dev.failsafe.ExecutionContext;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.casbin.adapter.CasbinRule;
import org.casbin.adapter.JDBCDataSource;
import org.casbin.jcasbin.model.Assertion;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.Adapter;
import org.casbin.jcasbin.persist.Helper;

abstract class JDBCBaseAdapter
implements Adapter {
    protected static final int _DEFAULT_CONNECTION_TRIES = 3;
    protected DataSource dataSource;
    private final int batchSize = 1000;
    protected Connection conn;
    protected RetryPolicy<Object> retryPolicy;

    protected JDBCBaseAdapter(String driver, String url, String username, String password) throws Exception {
        this(new JDBCDataSource(driver, url, username, password));
    }

    protected JDBCBaseAdapter(DataSource dataSource) throws Exception {
        this.dataSource = dataSource;
        this.migrate();
    }

    protected void migrate() throws SQLException {
        String productName;
        this.retryPolicy = ((RetryPolicyBuilder)RetryPolicy.builder().handle(SQLException.class)).withDelay(Duration.ofSeconds(1L)).withMaxRetries(3).build();
        this.conn = this.dataSource.getConnection();
        Statement stmt = this.conn.createStatement();
        String sql = "CREATE TABLE IF NOT EXISTS casbin_rule(id int NOT NULL PRIMARY KEY auto_increment, ptype VARCHAR(100) NOT NULL, v0 VARCHAR(100), v1 VARCHAR(100), v2 VARCHAR(100), v3 VARCHAR(100), v4 VARCHAR(100), v5 VARCHAR(100))";
        switch (productName = this.conn.getMetaData().getDatabaseProductName()) {
            case "MySQL": {
                String hasTableSql = "SHOW TABLES LIKE 'casbin_rule';";
                ResultSet rs = stmt.executeQuery(hasTableSql);
                if (!rs.next()) break;
                return;
            }
            case "Oracle": {
                sql = "declare begin execute immediate 'CREATE TABLE CASBIN_RULE(id NUMBER(5, 0) not NULL primary key, ptype VARCHAR(100) not NULL, v0 VARCHAR(100), v1 VARCHAR(100), v2 VARCHAR(100), v3 VARCHAR(100), v4 VARCHAR(100), v5 VARCHAR(100))'; exception when others then if SQLCODE = -955 then null; else raise; end if; end;";
                break;
            }
            case "Microsoft SQL Server": {
                sql = "IF NOT EXISTS (SELECT * FROM sysobjects WHERE name='casbin_rule' and xtype='U') CREATE TABLE casbin_rule(id int NOT NULL primary key identity(1, 1), ptype VARCHAR(100) NOT NULL, v0 VARCHAR(100), v1 VARCHAR(100), v2 VARCHAR(100), v3 VARCHAR(100), v4 VARCHAR(100), v5 VARCHAR(100))";
                break;
            }
            case "PostgreSQL": {
                sql = "CREATE SEQUENCE IF NOT EXISTS CASBIN_SEQUENCE START 1;";
            }
        }
        stmt.executeUpdate(sql);
        if (productName.equals("Oracle")) {
            sql = "declare V_NUM number;BEGIN V_NUM := 0;  select count(0) into V_NUM from user_sequences where sequence_name = 'CASBIN_SEQUENCE';if V_NUM > 0 then null;else execute immediate 'CREATE SEQUENCE casbin_sequence increment by 1 start with 1 nomaxvalue nocycle nocache';end if;END;";
            stmt.executeUpdate(sql);
            sql = "declare V_NUM number;BEGIN V_NUM := 0;select count(0) into V_NUM from user_triggers where trigger_name = 'CASBIN_ID_AUTOINCREMENT';if V_NUM > 0 then null;else execute immediate 'create trigger casbin_id_autoincrement before                         insert on CASBIN_RULE for each row                         when (new.id is null)                         begin                         select casbin_sequence.nextval into:new.id from dual;                        end;';end if;END;";
            stmt.executeUpdate(sql);
        } else if (productName.equals("PostgreSQL")) {
            sql = "CREATE TABLE IF NOT EXISTS casbin_rule(id int NOT NULL PRIMARY KEY default nextval('CASBIN_SEQUENCE'::regclass), ptype VARCHAR(100) NOT NULL, v0 VARCHAR(100), v1 VARCHAR(100), v2 VARCHAR(100), v3 VARCHAR(100), v4 VARCHAR(100), v5 VARCHAR(100))";
            stmt.executeUpdate(sql);
        }
    }

    protected void loadPolicyLine(CasbinRule line, Model model) {
        String lineText = line.ptype;
        if (!line.v0.equals("")) {
            lineText = lineText + ", " + line.v0;
        }
        if (!line.v1.equals("")) {
            lineText = lineText + ", " + line.v1;
        }
        if (!line.v2.equals("")) {
            lineText = lineText + ", " + line.v2;
        }
        if (!line.v3.equals("")) {
            lineText = lineText + ", " + line.v3;
        }
        if (!line.v4.equals("")) {
            lineText = lineText + ", " + line.v4;
        }
        if (!line.v5.equals("")) {
            lineText = lineText + ", " + line.v5;
        }
        Helper.loadPolicyLine((String)lineText, (Model)model);
    }

    public void loadPolicy(Model model) {
        Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).run(ctx -> {
            if (ctx.isRetry()) {
                this.retry((ExecutionContext<Void>)ctx);
            }
            try (Statement stmt = this.conn.createStatement();
                 ResultSet rSet = stmt.executeQuery("SELECT * FROM casbin_rule");){
                ResultSetMetaData rData = rSet.getMetaData();
                while (rSet.next()) {
                    CasbinRule line = new CasbinRule();
                    for (int i = 1; i <= rData.getColumnCount(); ++i) {
                        if (i == 2) {
                            line.ptype = rSet.getObject(i) == null ? "" : (String)rSet.getObject(i);
                            continue;
                        }
                        if (i == 3) {
                            line.v0 = rSet.getObject(i) == null ? "" : (String)rSet.getObject(i);
                            continue;
                        }
                        if (i == 4) {
                            line.v1 = rSet.getObject(i) == null ? "" : (String)rSet.getObject(i);
                            continue;
                        }
                        if (i == 5) {
                            line.v2 = rSet.getObject(i) == null ? "" : (String)rSet.getObject(i);
                            continue;
                        }
                        if (i == 6) {
                            line.v3 = rSet.getObject(i) == null ? "" : (String)rSet.getObject(i);
                            continue;
                        }
                        if (i == 7) {
                            line.v4 = rSet.getObject(i) == null ? "" : (String)rSet.getObject(i);
                            continue;
                        }
                        if (i != 8) continue;
                        line.v5 = rSet.getObject(i) == null ? "" : (String)rSet.getObject(i);
                    }
                    this.loadPolicyLine(line, model);
                }
            }
        });
    }

    private CasbinRule savePolicyLine(String ptype, List<String> rule) {
        CasbinRule line = new CasbinRule();
        line.ptype = ptype;
        if (rule.size() > 0) {
            line.v0 = rule.get(0);
        }
        if (rule.size() > 1) {
            line.v1 = rule.get(1);
        }
        if (rule.size() > 2) {
            line.v2 = rule.get(2);
        }
        if (rule.size() > 3) {
            line.v3 = rule.get(3);
        }
        if (rule.size() > 4) {
            line.v4 = rule.get(4);
        }
        if (rule.size() > 5) {
            line.v5 = rule.get(5);
        }
        return line;
    }

    public void savePolicy(Model model) {
        String cleanSql = "delete from casbin_rule";
        String addSql = "INSERT INTO casbin_rule (ptype,v0,v1,v2,v3,v4,v5) VALUES(?,?,?,?,?,?,?)";
        Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).run(ctx -> {
            if (ctx.isRetry()) {
                this.retry((ExecutionContext<Void>)ctx);
            }
            this.conn.setAutoCommit(false);
            int count = 0;
            try (Statement statement = this.conn.createStatement();
                 PreparedStatement ps = this.conn.prepareStatement(addSql);){
                CasbinRule line;
                Assertion ast;
                String ptype;
                statement.execute(cleanSql);
                for (Map.Entry entry : ((Map)model.model.get("p")).entrySet()) {
                    ptype = (String)entry.getKey();
                    ast = (Assertion)entry.getValue();
                    for (List rule : ast.policy) {
                        line = this.savePolicyLine(ptype, rule);
                        ps.setString(1, line.ptype);
                        ps.setString(2, line.v0);
                        ps.setString(3, line.v1);
                        ps.setString(4, line.v2);
                        ps.setString(5, line.v3);
                        ps.setString(6, line.v4);
                        ps.setString(7, line.v5);
                        ps.addBatch();
                        if (++count % 1000 != 0) continue;
                        ps.executeBatch();
                    }
                }
                for (Map.Entry entry : ((Map)model.model.get("g")).entrySet()) {
                    ptype = (String)entry.getKey();
                    ast = (Assertion)entry.getValue();
                    for (List rule : ast.policy) {
                        line = this.savePolicyLine(ptype, rule);
                        ps.setString(1, line.ptype);
                        ps.setString(2, line.v0);
                        ps.setString(3, line.v1);
                        ps.setString(4, line.v2);
                        ps.setString(5, line.v3);
                        ps.setString(6, line.v4);
                        ps.setString(7, line.v5);
                        ps.addBatch();
                        if (++count % 1000 != 0) continue;
                        ps.executeBatch();
                    }
                }
                ps.executeBatch();
                this.conn.commit();
            }
            catch (SQLException e) {
                this.conn.rollback();
                e.printStackTrace();
                throw e;
            }
            finally {
                this.conn.setAutoCommit(true);
            }
        });
    }

    public void addPolicy(String sec, String ptype, List<String> rule) {
        if (CollectionUtils.isEmpty(rule)) {
            return;
        }
        String sql = "INSERT INTO casbin_rule (ptype,v0,v1,v2,v3,v4,v5) VALUES(?,?,?,?,?,?,?)";
        Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).run(ctx -> {
            if (ctx.isRetry()) {
                this.retry((ExecutionContext<Void>)ctx);
            }
            try (PreparedStatement ps = this.conn.prepareStatement(sql);){
                CasbinRule line = this.savePolicyLine(ptype, rule);
                ps.setString(1, line.ptype);
                ps.setString(2, line.v0);
                ps.setString(3, line.v1);
                ps.setString(4, line.v2);
                ps.setString(5, line.v3);
                ps.setString(6, line.v4);
                ps.setString(7, line.v5);
                ps.addBatch();
                ps.executeBatch();
            }
        });
    }

    public void removePolicy(String sec, String ptype, List<String> rule) {
        if (CollectionUtils.isEmpty(rule)) {
            return;
        }
        this.removeFilteredPolicy(sec, ptype, 0, rule.toArray(new String[0]));
    }

    public void removeFilteredPolicy(String sec, String ptype, int fieldIndex, String ... fieldValues) {
        List values = Optional.of(Arrays.asList(fieldValues)).orElse(new ArrayList());
        if (CollectionUtils.isEmpty((Collection)values)) {
            return;
        }
        Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).run(ctx -> {
            if (ctx.isRetry()) {
                this.retry((ExecutionContext<Void>)ctx);
            }
            String sql = "DELETE FROM casbin_rule WHERE ptype = ?";
            int columnIndex = fieldIndex;
            for (int i = 0; i < values.size(); ++i) {
                sql = String.format("%s%s%s%s", sql, " AND v", columnIndex, " = ?");
                ++columnIndex;
            }
            try (PreparedStatement ps = this.conn.prepareStatement(sql);){
                ps.setString(1, ptype);
                for (int j = 0; j < values.size(); ++j) {
                    ps.setString(j + 2, (String)values.get(j));
                }
                ps.addBatch();
                ps.executeBatch();
            }
        });
    }

    public void close() throws SQLException {
        this.conn.close();
    }

    protected void retry(ExecutionContext<Void> ctx) throws SQLException {
        if (ctx.getExecutionCount() >= 3) {
            throw new Error(ctx.getLastFailure());
        }
        this.conn = this.dataSource.getConnection();
    }
}

