/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.cargo:cargo-maven2-plugin:1.2.0", 0);
        this.append(sb, "", 0);
        this.append(sb, "Cargo Maven 2 Plugin", 0);
        this.append(sb, "Cargo Maven 2 Plugin", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 16 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "configure".equals(this.goal)) {
            this.append(sb, "cargo:configure", 0);
            this.append(sb, "Mojo to create a local container standalone configuration at a specified directory.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "configuration", 2);
                this.append(sb, "Configures a Cargo Configuration. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "container", 2);
                this.append(sb, "Configures a Cargo Container. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployer", 2);
                this.append(sb, "Configures a Cargo Deployer. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Set this to 'true' to bypass cargo execution.", 3);
                this.append(sb, "Expression: ${cargo.maven.skip}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "deploy".equals(this.goal)) {
            this.append(sb, "cargo:deploy", 0);
            this.append(sb, "Class used uniquely to provide a goal alias for deployer-deploy.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "configuration", 2);
                this.append(sb, "Configures a Cargo Configuration. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "container", 2);
                this.append(sb, "Configures a Cargo Container. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployer", 2);
                this.append(sb, "Configures a Cargo Deployer. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Set this to 'true' to bypass cargo execution.", 3);
                this.append(sb, "Expression: ${cargo.maven.skip}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "deployer-deploy".equals(this.goal)) {
            this.append(sb, "cargo:deployer-deploy", 0);
            this.append(sb, "Deploy a deployable to a container.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "configuration", 2);
                this.append(sb, "Configures a Cargo Configuration. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "container", 2);
                this.append(sb, "Configures a Cargo Container. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployer", 2);
                this.append(sb, "Configures a Cargo Deployer. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Set this to 'true' to bypass cargo execution.", 3);
                this.append(sb, "Expression: ${cargo.maven.skip}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "deployer-redeploy".equals(this.goal)) {
            this.append(sb, "cargo:deployer-redeploy", 0);
            this.append(sb, "Redeploy a deployable (i.e. undeploy and deploy it again) in a container.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "configuration", 2);
                this.append(sb, "Configures a Cargo Configuration. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "container", 2);
                this.append(sb, "Configures a Cargo Container. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployer", 2);
                this.append(sb, "Configures a Cargo Deployer. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Set this to 'true' to bypass cargo execution.", 3);
                this.append(sb, "Expression: ${cargo.maven.skip}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "deployer-start".equals(this.goal)) {
            this.append(sb, "cargo:deployer-start", 0);
            this.append(sb, "Start a deployable which is already installed in a container.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "configuration", 2);
                this.append(sb, "Configures a Cargo Configuration. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "container", 2);
                this.append(sb, "Configures a Cargo Container. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployer", 2);
                this.append(sb, "Configures a Cargo Deployer. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Set this to 'true' to bypass cargo execution.", 3);
                this.append(sb, "Expression: ${cargo.maven.skip}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "deployer-stop".equals(this.goal)) {
            this.append(sb, "cargo:deployer-stop", 0);
            this.append(sb, "Stop a deployable which is already deployed in a container.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "configuration", 2);
                this.append(sb, "Configures a Cargo Configuration. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "container", 2);
                this.append(sb, "Configures a Cargo Container. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployer", 2);
                this.append(sb, "Configures a Cargo Deployer. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Set this to 'true' to bypass cargo execution.", 3);
                this.append(sb, "Expression: ${cargo.maven.skip}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "deployer-undeploy".equals(this.goal)) {
            this.append(sb, "cargo:deployer-undeploy", 0);
            this.append(sb, "Undeploy a deployable from a container.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "configuration", 2);
                this.append(sb, "Configures a Cargo Configuration. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "container", 2);
                this.append(sb, "Configures a Cargo Container. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployer", 2);
                this.append(sb, "Configures a Cargo Deployer. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Set this to 'true' to bypass cargo execution.", 3);
                this.append(sb, "Expression: ${cargo.maven.skip}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "cargo:help", 0);
            this.append(sb, "Display help information on cargo-maven2-plugin.\nCall\n\u00a0\u00a0mvn\u00a0cargo:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "install".equals(this.goal)) {
            this.append(sb, "cargo:install", 0);
            this.append(sb, "Installs a container into a given directory. If the container is already installed nothing happens. The container is defined using the <container> element as described in the Cargo Maven2 plugin reference guide.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "configuration", 2);
                this.append(sb, "Configures a Cargo Configuration. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "container", 2);
                this.append(sb, "Configures a Cargo Container. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployer", 2);
                this.append(sb, "Configures a Cargo Deployer. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Set this to 'true' to bypass cargo execution.", 3);
                this.append(sb, "Expression: ${cargo.maven.skip}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "package".equals(this.goal)) {
            this.append(sb, "cargo:package", 0);
            this.append(sb, "Package a container distribution, a Configuration and deployed deployables. See Packager.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "configuration", 2);
                this.append(sb, "Configures a Cargo Configuration. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "container", 2);
                this.append(sb, "Configures a Cargo Container. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployer", 2);
                this.append(sb, "Configures a Cargo Deployer. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "packager", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Set this to 'true' to bypass cargo execution.", 3);
                this.append(sb, "Expression: ${cargo.maven.skip}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "redeploy".equals(this.goal)) {
            this.append(sb, "cargo:redeploy", 0);
            this.append(sb, "Class used uniquely to provide a goal alias for deployer-redeploy.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "configuration", 2);
                this.append(sb, "Configures a Cargo Configuration. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "container", 2);
                this.append(sb, "Configures a Cargo Container. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployer", 2);
                this.append(sb, "Configures a Cargo Deployer. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Set this to 'true' to bypass cargo execution.", 3);
                this.append(sb, "Expression: ${cargo.maven.skip}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "run".equals(this.goal)) {
            this.append(sb, "cargo:run", 0);
            this.append(sb, "Start a container using Cargo and wait until user pressed CTRL + C to stop.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "configuration", 2);
                this.append(sb, "Configures a Cargo Configuration. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "container", 2);
                this.append(sb, "Configures a Cargo Container. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "containerId", 2);
                this.append(sb, "Sets the container id.", 3);
                this.append(sb, "Expression: ${cargo.maven.containerId}", 3);
                this.append(sb, "", 0);
                this.append(sb, "containerUrl", 2);
                this.append(sb, "Sets the container download URL.", 3);
                this.append(sb, "Expression: ${cargo.maven.containerUrl}", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployer", 2);
                this.append(sb, "Configures a Cargo Deployer. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Set this to 'true' to bypass cargo execution.", 3);
                this.append(sb, "Expression: ${cargo.maven.skip}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "start".equals(this.goal)) {
            this.append(sb, "cargo:start", 0);
            this.append(sb, "Start a container using Cargo.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "configuration", 2);
                this.append(sb, "Configures a Cargo Configuration. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "container", 2);
                this.append(sb, "Configures a Cargo Container. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployer", 2);
                this.append(sb, "Configures a Cargo Deployer. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Set this to 'true' to bypass cargo execution.", 3);
                this.append(sb, "Expression: ${cargo.maven.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "wait (Default: false)", 2);
                this.append(sb, "Deprecated. The wait parameter is now deprecated, please use cargo:run instead", 3);
                this.append(sb, "", 0);
                this.append(sb, "Decides whether to wait after the container is started or to return the execution flow to the user.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${cargo.maven.wait}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "stop".equals(this.goal)) {
            this.append(sb, "cargo:stop", 0);
            this.append(sb, "Stop a running container using Cargo.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "configuration", 2);
                this.append(sb, "Configures a Cargo Configuration. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "container", 2);
                this.append(sb, "Configures a Cargo Container. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployer", 2);
                this.append(sb, "Configures a Cargo Deployer. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Set this to 'true' to bypass cargo execution.", 3);
                this.append(sb, "Expression: ${cargo.maven.skip}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "uberwar".equals(this.goal)) {
            this.append(sb, "cargo:uberwar", 0);
            this.append(sb, "Builds an uber war.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "archive", 2);
                this.append(sb, "The archive configuration to use. See Maven Archiver Reference.", 3);
                this.append(sb, "", 0);
                this.append(sb, "descriptor", 2);
                this.append(sb, "The file name to use for the merge descriptor.", 3);
                this.append(sb, "", 0);
                this.append(sb, "descriptorId", 2);
                this.append(sb, "The id to use for the merge descriptor.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "The directory for the generated WAR.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.directory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "resolveDependencies", 2);
                this.append(sb, "Attempt to resolve dependencies, rather than simply merging the files in WEB-INF/lib. This is an experimental feature.", 3);
                this.append(sb, "", 0);
                this.append(sb, "warName", 2);
                this.append(sb, "The name of the generated WAR.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project.build.finalName}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "undeploy".equals(this.goal)) {
            this.append(sb, "cargo:undeploy", 0);
            this.append(sb, "Class used uniquely to provide a goal alias for deployer-undeploy.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "configuration", 2);
                this.append(sb, "Configures a Cargo Configuration. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "container", 2);
                this.append(sb, "Configures a Cargo Container. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployer", 2);
                this.append(sb, "Configures a Cargo Deployer. See the Cargo Maven2 plugin reference guide for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Set this to 'true' to bypass cargo execution.", 3);
                this.append(sb, "Expression: ${cargo.maven.skip}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

