/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2.configuration;

import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDependency {
    private String groupId;
    private String artifactId;
    private String type;
    private String location;
    private String classifier;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getClassifier() {
        return this.classifier;
    }

    protected String findArtifactLocation(Set<Artifact> artifacts, Log log) throws MojoExecutionException {
        Artifact resolvedArtifact = null;
        log.debug((CharSequence)("Searching for an artifact that matches [" + this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getType() + ":" + this.getClassifier() + "]..."));
        for (Artifact artifact : artifacts) {
            log.debug((CharSequence)("Checking artifact [" + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + ":" + artifact.getClassifier() + "]..."));
            if (!artifact.getGroupId().equals(this.getGroupId()) || !artifact.getArtifactId().equals(this.getArtifactId()) || artifact.getClassifier() != this.getClassifier() && (artifact.getClassifier() == null || !artifact.getClassifier().equals(this.getClassifier())) || artifact.getType() != this.getType() && (artifact.getType() == null || !artifact.getType().equals(this.getType()))) continue;
            resolvedArtifact = artifact;
            break;
        }
        if (resolvedArtifact == null) {
            throw new MojoExecutionException("Artifact [" + this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getType() + "] is not a dependency of the project.");
        }
        return resolvedArtifact.getFile().getPath();
    }

    public String toString() {
        return "AbstractDependency{ groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", type=" + this.type + ", classifier=" + this.classifier + " }";
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof AbstractDependency)) {
            return false;
        }
        return this.toString().equals(((AbstractDependency)other).toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

