/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.ext.gfm.tables.internal;

import java.util.ArrayList;
import java.util.List;
import org.commonmark.ext.gfm.tables.TableBlock;
import org.commonmark.ext.gfm.tables.TableBody;
import org.commonmark.ext.gfm.tables.TableCell;
import org.commonmark.ext.gfm.tables.TableHead;
import org.commonmark.ext.gfm.tables.TableRow;
import org.commonmark.internal.util.Parsing;
import org.commonmark.node.Block;
import org.commonmark.node.Node;
import org.commonmark.node.SourceSpan;
import org.commonmark.parser.InlineParser;
import org.commonmark.parser.SourceLine;
import org.commonmark.parser.SourceLines;
import org.commonmark.parser.block.AbstractBlockParser;
import org.commonmark.parser.block.AbstractBlockParserFactory;
import org.commonmark.parser.block.BlockContinue;
import org.commonmark.parser.block.BlockParser;
import org.commonmark.parser.block.BlockStart;
import org.commonmark.parser.block.MatchedBlockParser;
import org.commonmark.parser.block.ParserState;

public class TableBlockParser
extends AbstractBlockParser {
    private final TableBlock block = new TableBlock();
    private final List<SourceLine> rowLines = new ArrayList<SourceLine>();
    private final List<TableCell.Alignment> columns;

    private TableBlockParser(List<TableCell.Alignment> columns, SourceLine headerLine) {
        this.columns = columns;
        this.rowLines.add(headerLine);
    }

    public boolean canHaveLazyContinuationLines() {
        return true;
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockContinue tryContinue(ParserState state) {
        if (Parsing.find((char)'|', (CharSequence)state.getLine().getContent(), (int)0) != -1) {
            return BlockContinue.atIndex((int)state.getIndex());
        }
        return BlockContinue.none();
    }

    public void addLine(SourceLine line) {
        this.rowLines.add(line);
    }

    public void parseInlines(InlineParser inlineParser) {
        List sourceSpans = this.block.getSourceSpans();
        SourceSpan headerSourceSpan = !sourceSpans.isEmpty() ? (SourceSpan)sourceSpans.get(0) : null;
        TableHead head = new TableHead();
        if (headerSourceSpan != null) {
            head.addSourceSpan(headerSourceSpan);
        }
        this.block.appendChild((Node)head);
        TableRow headerRow = new TableRow();
        headerRow.setSourceSpans(head.getSourceSpans());
        head.appendChild((Node)headerRow);
        List<SourceLine> headerCells = TableBlockParser.split(this.rowLines.get(0));
        int headerColumns = headerCells.size();
        for (int i = 0; i < headerColumns; ++i) {
            SourceLine cell = headerCells.get(i);
            TableCell tableCell = this.parseCell(cell, i, inlineParser);
            tableCell.setHeader(true);
            headerRow.appendChild((Node)tableCell);
        }
        TableBody body = null;
        for (int rowIndex = 2; rowIndex < this.rowLines.size(); ++rowIndex) {
            SourceLine rowLine = this.rowLines.get(rowIndex);
            SourceSpan sourceSpan = rowIndex < sourceSpans.size() ? (SourceSpan)sourceSpans.get(rowIndex) : null;
            List<SourceLine> cells = TableBlockParser.split(rowLine);
            TableRow row = new TableRow();
            if (sourceSpan != null) {
                row.addSourceSpan(sourceSpan);
            }
            for (int i = 0; i < headerColumns; ++i) {
                SourceLine cell = i < cells.size() ? cells.get(i) : SourceLine.of((CharSequence)"", null);
                TableCell tableCell = this.parseCell(cell, i, inlineParser);
                row.appendChild((Node)tableCell);
            }
            if (body == null) {
                body = new TableBody();
                this.block.appendChild((Node)body);
            }
            body.appendChild((Node)row);
            body.addSourceSpan(sourceSpan);
        }
    }

    private TableCell parseCell(SourceLine cell, int column, InlineParser inlineParser) {
        TableCell tableCell = new TableCell();
        SourceSpan sourceSpan = cell.getSourceSpan();
        if (sourceSpan != null) {
            tableCell.addSourceSpan(sourceSpan);
        }
        if (column < this.columns.size()) {
            tableCell.setAlignment(this.columns.get(column));
        }
        CharSequence content = cell.getContent();
        int start = Parsing.skipSpaceTab((CharSequence)content, (int)0, (int)content.length());
        int end = Parsing.skipSpaceTabBackwards((CharSequence)content, (int)(content.length() - 1), (int)start);
        inlineParser.parse(SourceLines.of((SourceLine)cell.substring(start, end + 1)), (Node)tableCell);
        return tableCell;
    }

    private static List<SourceLine> split(SourceLine line) {
        int nonSpace;
        CharSequence row = line.getContent();
        int cellStart = nonSpace = Parsing.skipSpaceTab((CharSequence)row, (int)0, (int)row.length());
        int cellEnd = row.length();
        if (row.charAt(nonSpace) == '|') {
            cellStart = nonSpace + 1;
            int nonSpaceEnd = Parsing.skipSpaceTabBackwards((CharSequence)row, (int)(row.length() - 1), (int)(cellStart + 1));
            cellEnd = nonSpaceEnd + 1;
        }
        ArrayList<SourceLine> cells = new ArrayList<SourceLine>();
        StringBuilder sb = new StringBuilder();
        block4: for (int i = cellStart; i < cellEnd; ++i) {
            char c = row.charAt(i);
            switch (c) {
                case '\\': {
                    if (i + 1 < cellEnd && row.charAt(i + 1) == '|') {
                        sb.append('|');
                        ++i;
                        continue block4;
                    }
                    sb.append('\\');
                    continue block4;
                }
                case '|': {
                    String content = sb.toString();
                    cells.add(SourceLine.of((CharSequence)content, (SourceSpan)line.substring(cellStart, i).getSourceSpan()));
                    sb.setLength(0);
                    cellStart = i + 1;
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (sb.length() > 0) {
            String content = sb.toString();
            cells.add(SourceLine.of((CharSequence)content, (SourceSpan)line.substring(cellStart, line.getContent().length()).getSourceSpan()));
        }
        return cells;
    }

    private static List<TableCell.Alignment> parseSeparator(CharSequence s) {
        ArrayList<TableCell.Alignment> columns = new ArrayList<TableCell.Alignment>();
        int pipes = 0;
        boolean valid = false;
        int i = 0;
        block5: while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '|': {
                    ++i;
                    if (++pipes > 1) {
                        return null;
                    }
                    valid = true;
                    continue block5;
                }
                case '-': 
                case ':': {
                    if (pipes == 0 && !columns.isEmpty()) {
                        return null;
                    }
                    boolean left = false;
                    boolean right = false;
                    if (c == ':') {
                        left = true;
                        ++i;
                    }
                    boolean haveDash = false;
                    while (i < s.length() && s.charAt(i) == '-') {
                        ++i;
                        haveDash = true;
                    }
                    if (!haveDash) {
                        return null;
                    }
                    if (i < s.length() && s.charAt(i) == ':') {
                        right = true;
                        ++i;
                    }
                    columns.add(TableBlockParser.getAlignment(left, right));
                    pipes = 0;
                    continue block5;
                }
                case '\t': 
                case ' ': {
                    ++i;
                    continue block5;
                }
            }
            return null;
        }
        if (!valid) {
            return null;
        }
        return columns;
    }

    private static TableCell.Alignment getAlignment(boolean left, boolean right) {
        if (left && right) {
            return TableCell.Alignment.CENTER;
        }
        if (left) {
            return TableCell.Alignment.LEFT;
        }
        if (right) {
            return TableCell.Alignment.RIGHT;
        }
        return null;
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            SourceLine line;
            SourceLine separatorLine;
            List columns;
            List paragraphLines = matchedBlockParser.getParagraphLines().getLines();
            if (paragraphLines.size() == 1 && Parsing.find((char)'|', (CharSequence)((SourceLine)paragraphLines.get(0)).getContent(), (int)0) != -1 && (columns = TableBlockParser.parseSeparator((separatorLine = (line = state.getLine()).substring(state.getIndex(), line.getContent().length())).getContent())) != null && !columns.isEmpty()) {
                SourceLine paragraph = (SourceLine)paragraphLines.get(0);
                List headerCells = TableBlockParser.split(paragraph);
                if (columns.size() >= headerCells.size()) {
                    return BlockStart.of((BlockParser[])new BlockParser[]{new TableBlockParser(columns, paragraph)}).atIndex(state.getIndex()).replaceActiveBlockParser();
                }
            }
            return BlockStart.none();
        }
    }
}

