/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.bls;

import com.google.common.base.Preconditions;
import org.dashj.bls.AggregationInfoVector;
import org.dashj.bls.BigIntegerVector;
import org.dashj.bls.JNI;
import org.dashj.bls.MessageHashVector;
import org.dashj.bls.PublicKey;
import org.dashj.bls.PublicKeyVector;
import org.dashj.bls.SWIGTYPE_p_bn_t;

public class AggregationInfo {
    private transient long cPointer;
    protected transient boolean owner;

    protected AggregationInfo(long cPtr, boolean cMemoryOwn) {
        Preconditions.checkArgument((cPtr != 0L ? 1 : 0) != 0);
        this.owner = cMemoryOwn;
        this.cPointer = cPtr;
    }

    protected static long getCPtr(AggregationInfo obj) {
        return obj == null ? 0L : obj.cPointer;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.cPointer != 0L) {
            if (this.owner) {
                this.owner = false;
                JNI.delete_AggregationInfo(this.cPointer);
            }
            this.cPointer = 0L;
        }
    }

    public static AggregationInfo FromMsgHash(PublicKey pk, byte[] messageHash) {
        Preconditions.checkNotNull((Object)pk);
        Preconditions.checkNotNull((Object)messageHash);
        return new AggregationInfo(JNI.AggregationInfo_FromMsgHash(PublicKey.getCPtr(pk), pk, messageHash), true);
    }

    public static AggregationInfo FromMsg(PublicKey pk, byte[] message, long len) {
        Preconditions.checkNotNull((Object)pk);
        Preconditions.checkNotNull((Object)message);
        Preconditions.checkState(((long)message.length >= len ? 1 : 0) != 0);
        return new AggregationInfo(JNI.AggregationInfo_FromMsg(PublicKey.getCPtr(pk), pk, message, len), true);
    }

    public static AggregationInfo FromVectors(PublicKeyVector pubKeys, MessageHashVector messageHashes, BigIntegerVector exponents) {
        Preconditions.checkNotNull((Object)pubKeys);
        Preconditions.checkNotNull((Object)messageHashes);
        Preconditions.checkNotNull((Object)exponents);
        Preconditions.checkArgument((pubKeys.size() == messageHashes.size() ? 1 : 0) != 0, (Object)("Invalid input, all std::vectors must have the same length (" + pubKeys.size() + " != " + messageHashes.size() + ")"));
        return new AggregationInfo(JNI.AggregationInfo_FromVectors(PublicKeyVector.getCPtr(pubKeys), pubKeys, MessageHashVector.getCPtr(messageHashes), messageHashes, BigIntegerVector.getCPtr(exponents), exponents), true);
    }

    public static AggregationInfo MergeInfos(AggregationInfoVector infos) {
        Preconditions.checkNotNull((Object)infos);
        return new AggregationInfo(JNI.AggregationInfo_MergeInfos(AggregationInfoVector.getCPtr(infos)), true);
    }

    public AggregationInfo(AggregationInfo info) {
        this(JNI.new_AggregationInfo__SWIG_0(AggregationInfo.getCPtr(info), info), true);
    }

    public void RemoveEntries(MessageHashVector messages, PublicKeyVector pubKeys) {
        Preconditions.checkNotNull((Object)messages);
        Preconditions.checkNotNull((Object)pubKeys);
        Preconditions.checkArgument((messages.size() != pubKeys.size() ? 1 : 0) != 0, (Object)"Invalid entries");
        JNI.AggregationInfo_RemoveEntries(this.cPointer, this, MessageHashVector.getCPtr(messages), messages, PublicKeyVector.getCPtr(pubKeys), pubKeys);
    }

    public void GetExponent(SWIGTYPE_p_bn_t result, byte[] messageHash, PublicKey pubkey) {
        JNI.AggregationInfo_GetExponent(this.cPointer, this, SWIGTYPE_p_bn_t.getCPtr(result), messageHash, PublicKey.getCPtr(pubkey), pubkey);
    }

    public PublicKeyVector GetPubKeys() {
        return new PublicKeyVector(JNI.AggregationInfo_GetPubKeys(this.cPointer, this), true);
    }

    public MessageHashVector GetMessageHashes() {
        return new MessageHashVector(JNI.AggregationInfo_GetMessageHashes(this.cPointer, this), true);
    }

    public boolean Empty() {
        return JNI.AggregationInfo_Empty(this.cPointer, this);
    }

    public AggregationInfo() {
        this(JNI.new_AggregationInfo__SWIG_1(), true);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AggregationInfo)) {
            return false;
        }
        AggregationInfo aggInfo = (AggregationInfo)obj;
        MessageHashVector otherMessageHashes = aggInfo.GetMessageHashes();
        PublicKeyVector otherPublicKeys = aggInfo.GetPubKeys();
        return JNI.AggregationInfo_Equals(this.cPointer, this, AggregationInfo.getCPtr(aggInfo), aggInfo);
    }

    public String toString() {
        return "AggregationInfo(PublicKeys: " + this.GetPubKeys().size() + ", MessageHashes: " + this.GetMessageHashes().size() + ")";
    }
}

