/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.bls;

import com.google.common.base.Preconditions;
import java.util.AbstractList;
import java.util.Collection;
import org.dashj.bls.AggregationInfo;
import org.dashj.bls.JNI;

public class AggregationInfoVector
extends AbstractList<AggregationInfo> {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected AggregationInfoVector(long cPtr, boolean cMemoryOwn) {
        Preconditions.checkArgument((cPtr != 0L ? 1 : 0) != 0);
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(AggregationInfoVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                JNI.delete_AggregationInfoVector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public AggregationInfoVector(Collection<AggregationInfo> e) {
        Preconditions.checkNotNull(e);
        this.reserve(e.size());
        for (AggregationInfo value : e) {
            this.push_back(value);
        }
    }

    public AggregationInfoVector() {
        this(JNI.new_AggregationInfoVector__SWIG_0(), true);
    }

    public AggregationInfoVector(AggregationInfoVector o) {
        this(JNI.new_AggregationInfoVector__SWIG_2(AggregationInfoVector.getCPtr(o), o), true);
    }

    public long capacity() {
        return JNI.AggregationInfoVector_capacity(this.swigCPtr, this);
    }

    public void reserve(long n) {
        JNI.AggregationInfoVector_reserve(this.swigCPtr, this, n);
    }

    @Override
    public boolean isEmpty() {
        return JNI.AggregationInfoVector_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        JNI.AggregationInfoVector_clear(this.swigCPtr, this);
    }

    public void push_back(AggregationInfo x) {
        Preconditions.checkNotNull((Object)x);
        JNI.AggregationInfoVector_push_back(this.swigCPtr, this, AggregationInfo.getCPtr(x), x);
    }

    @Override
    public AggregationInfo get(int i) {
        return new AggregationInfo(JNI.AggregationInfoVector_get(this.swigCPtr, this, i), false);
    }

    @Override
    public AggregationInfo set(int i, AggregationInfo VECTOR_VALUE_IN) {
        Preconditions.checkNotNull((Object)VECTOR_VALUE_IN);
        return new AggregationInfo(JNI.AggregationInfoVector_set(this.swigCPtr, this, i, AggregationInfo.getCPtr(VECTOR_VALUE_IN), VECTOR_VALUE_IN), true);
    }

    @Override
    public int size() {
        return JNI.AggregationInfoVector_size(this.swigCPtr, this);
    }

    @Override
    public void removeRange(int from, int to) {
        JNI.AggregationInfoVector_removeRange(this.swigCPtr, this, from, to);
    }
}

