/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.bls;

import com.google.common.base.Preconditions;
import org.dashj.bls.JNI;
import org.dashj.bls.MessageHashVector;
import org.dashj.bls.SWIGTYPE_p_bn_t;
import org.dashj.bls.SWIGTYPE_p_std__vectorT_size_t_t;

public class BLS {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
    public static final String DASHJ_VERSION = "0.17.5";
    public static final long MESSAGE_HASH_LEN;
    public static long STS_OK;
    public static long STS_ERR;

    protected BLS(long cPtr, boolean cMemoryOwn) {
        Preconditions.checkArgument((cPtr != 0L ? 1 : 0) != 0);
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(BLS obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                JNI.delete_BLS(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static String getGROUP_ORDER() {
        return JNI.BLS_GROUP_ORDER_get();
    }

    public static boolean Init() {
        return JNI.BLS_Init();
    }

    public static void HashPubKeys(SWIGTYPE_p_bn_t output, long numOutputs, MessageHashVector serPubKeys, SWIGTYPE_p_std__vectorT_size_t_t sortedIndices) {
        JNI.BLS_HashPubKeys(SWIGTYPE_p_bn_t.getCPtr(output), numOutputs, MessageHashVector.getCPtr(serPubKeys), serPubKeys, SWIGTYPE_p_std__vectorT_size_t_t.getCPtr(sortedIndices));
    }

    public static void CheckRelicErrors() {
        JNI.BLS_CheckRelicErrors();
    }

    public BLS() {
        this(JNI.new_BLS(), true);
    }

    static long GetContext() {
        return JNI.BLS_GetContext();
    }

    static long GetContextError() {
        return JNI.BLS_GetContextError();
    }

    static void SetContextError(long error) {
        JNI.BLS_SetContextError(error);
    }

    static String GetVersionString() {
        return JNI.BLS_GetVersionString();
    }

    static {
        try {
            System.loadLibrary(JNI.LIBRARY_NAME);
            Preconditions.checkState((boolean)BLS.GetVersionString().equals(DASHJ_VERSION), (Object)("dashjbls:  C++ Source Version doesn't match Java Source version:C++: " + BLS.GetVersionString() + " Java: " + DASHJ_VERSION));
            boolean isLibraryLoaded = true;
        }
        catch (UnsatisfiedLinkError x) {
            throw new RuntimeException(x.getMessage());
        }
        MESSAGE_HASH_LEN = JNI.BLS_MESSAGE_HASH_LEN_get();
        STS_OK = 0L;
        STS_ERR = 1L;
    }
}

