/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.bls;

import com.google.common.base.Preconditions;

public abstract class BLSObject {
    protected transient long cPointer;
    protected transient boolean owner;

    protected BLSObject(long cPointer, boolean owner) {
        Preconditions.checkArgument((cPointer != 0L ? 1 : 0) != 0);
        this.cPointer = cPointer;
        this.owner = owner;
    }

    protected static long getCPtr(BLSObject obj) {
        return obj == null ? 0L : obj.cPointer;
    }

    protected long getCPtr() {
        return this.cPointer;
    }

    protected boolean isOwner() {
        return this.owner;
    }

    protected void finalize() {
        this.handleDelete();
    }

    public synchronized void handleDelete() {
        if (this.cPointer != 0L) {
            if (this.owner) {
                this.owner = false;
                this.delete();
            }
            this.cPointer = 0L;
        }
    }

    protected abstract void delete();
}

