/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.bls;

import com.google.common.base.Preconditions;
import org.dashj.bls.BLSObject;
import org.dashj.bls.JNI;
import org.dashj.bls.Utils;

public class ChainCode
extends BLSObject {
    public static final long CHAIN_CODE_SIZE = JNI.ChainCode_CHAIN_CODE_SIZE_get();

    protected ChainCode(long cPtr, boolean cMemoryOwn) {
        super(cPtr, cMemoryOwn);
    }

    protected static long getCPtr(ChainCode obj) {
        return obj == null ? 0L : obj.cPointer;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        JNI.delete_ChainCode(this.cPointer);
    }

    public static ChainCode FromBytes(byte[] bytes) {
        Preconditions.checkNotNull((Object)bytes);
        Preconditions.checkArgument(((long)bytes.length == CHAIN_CODE_SIZE ? 1 : 0) != 0);
        return new ChainCode(JNI.ChainCode_FromBytes(bytes), true);
    }

    public ChainCode(ChainCode cc) {
        this(JNI.new_ChainCode(ChainCode.getCPtr(cc), cc), true);
    }

    public void Serialize(byte[] buffer) {
        Preconditions.checkNotNull((Object)buffer);
        Preconditions.checkArgument(((long)buffer.length >= CHAIN_CODE_SIZE ? 1 : 0) != 0);
        JNI.ChainCode_Serialize__SWIG_0(this.cPointer, this, buffer);
    }

    public byte[] Serialize() {
        byte[] bytes = new byte[(int)CHAIN_CODE_SIZE];
        this.Serialize(bytes);
        return bytes;
    }

    public String toString() {
        return "ChainCode(" + Utils.HEX.encode(this.Serialize()) + ")";
    }
}

