/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.bls;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.dashj.bls.BLSObject;
import org.dashj.bls.ChainCode;
import org.dashj.bls.ExtendedPublicKey;
import org.dashj.bls.JNI;
import org.dashj.bls.PrivateKey;
import org.dashj.bls.PublicKey;
import org.dashj.bls.Utils;

public class ExtendedPrivateKey
extends BLSObject {
    public static final long EXTENDED_PRIVATE_KEY_SIZE = JNI.ExtendedPrivateKey_EXTENDED_PRIVATE_KEY_SIZE_get();

    protected ExtendedPrivateKey(long cPtr, boolean cMemoryOwn) {
        super(cPtr, cMemoryOwn);
    }

    protected static long getCPtr(ExtendedPrivateKey obj) {
        return obj == null ? 0L : obj.cPointer;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        JNI.delete_ExtendedPrivateKey(this.cPointer);
    }

    public static ExtendedPrivateKey FromSeed(byte[] seed, long seedLen) {
        Preconditions.checkNotNull((Object)seed);
        Preconditions.checkArgument((seedLen <= (long)seed.length ? 1 : 0) != 0);
        return new ExtendedPrivateKey(JNI.ExtendedPrivateKey_FromSeed(seed, seedLen), true);
    }

    public static ExtendedPrivateKey FromBytes(byte[] serialized) {
        Preconditions.checkNotNull((Object)serialized);
        Preconditions.checkArgument(((long)serialized.length == EXTENDED_PRIVATE_KEY_SIZE ? 1 : 0) != 0);
        return new ExtendedPrivateKey(JNI.ExtendedPrivateKey_FromBytes(serialized), true);
    }

    public ExtendedPrivateKey PrivateChild(long i) {
        return new ExtendedPrivateKey(JNI.ExtendedPrivateKey_PrivateChild(this.cPointer, this, i), true);
    }

    public ExtendedPublicKey PublicChild(long i) {
        return new ExtendedPublicKey(JNI.ExtendedPrivateKey_PublicChild(this.cPointer, this, i), true);
    }

    public long GetVersion() {
        return JNI.ExtendedPrivateKey_GetVersion(this.cPointer, this);
    }

    public short GetDepth() {
        return JNI.ExtendedPrivateKey_GetDepth(this.cPointer, this);
    }

    public long GetParentFingerprint() {
        return JNI.ExtendedPrivateKey_GetParentFingerprint(this.cPointer, this);
    }

    public long GetChildNumber() {
        return JNI.ExtendedPrivateKey_GetChildNumber(this.cPointer, this);
    }

    public ChainCode GetChainCode() {
        return new ChainCode(JNI.ExtendedPrivateKey_GetChainCode(this.cPointer, this), true);
    }

    public PrivateKey GetPrivateKey() {
        return new PrivateKey(JNI.ExtendedPrivateKey_GetPrivateKey(this.cPointer, this), true);
    }

    public PublicKey GetPublicKey() {
        return new PublicKey(JNI.ExtendedPrivateKey_GetPublicKey(this.cPointer, this), true);
    }

    public ExtendedPublicKey GetExtendedPublicKey() {
        return new ExtendedPublicKey(JNI.ExtendedPrivateKey_GetExtendedPublicKey(this.cPointer, this), true);
    }

    public void Serialize(byte[] buffer) {
        Preconditions.checkNotNull((Object)buffer);
        Preconditions.checkArgument(((long)buffer.length >= EXTENDED_PRIVATE_KEY_SIZE ? 1 : 0) != 0);
        JNI.ExtendedPrivateKey_Serialize__SWIG_0(this.cPointer, this, buffer);
    }

    public byte[] Serialize() {
        byte[] bytes = new byte[(int)EXTENDED_PRIVATE_KEY_SIZE];
        this.Serialize(bytes);
        return bytes;
    }

    public String toString() {
        return "ExtendedPrivateKey(" + Utils.HEX.encode(this.Serialize()) + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ExtendedPrivateKey)) {
            return false;
        }
        ExtendedPrivateKey epk = (ExtendedPrivateKey)obj;
        byte[] theseBytes = new byte[(int)EXTENDED_PRIVATE_KEY_SIZE];
        this.Serialize(theseBytes);
        byte[] bytes = new byte[(int)EXTENDED_PRIVATE_KEY_SIZE];
        epk.Serialize(bytes);
        return Arrays.equals(theseBytes, bytes);
    }
}

