/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.bls;

import com.google.common.base.Preconditions;
import org.dashj.bls.BLSObject;
import org.dashj.bls.InsecureSignatureVector;
import org.dashj.bls.JNI;
import org.dashj.bls.MessageHashVector;
import org.dashj.bls.PublicKey;
import org.dashj.bls.PublicKeyVector;
import org.dashj.bls.SWIGTYPE_p_g2_t;
import org.dashj.bls.Utils;

public class InsecureSignature
extends BLSObject {
    public static final long SIGNATURE_SIZE = JNI.InsecureSignature_SIGNATURE_SIZE_get();

    protected InsecureSignature(long cPtr, boolean cMemoryOwn) {
        super(cPtr, cMemoryOwn);
    }

    protected static long getCPtr(InsecureSignature obj) {
        return obj == null ? 0L : obj.cPointer;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        JNI.delete_InsecureSignature(this.cPointer);
    }

    public static InsecureSignature FromBytes(byte[] data) {
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkArgument(((long)data.length == SIGNATURE_SIZE ? 1 : 0) != 0);
        return new InsecureSignature(JNI.InsecureSignature_FromBytes(data), true);
    }

    public static InsecureSignature FromG2(SWIGTYPE_p_g2_t element) {
        return new InsecureSignature(JNI.InsecureSignature_FromG2(SWIGTYPE_p_g2_t.getCPtr(element)), true);
    }

    public InsecureSignature(InsecureSignature signature) {
        this(JNI.new_InsecureSignature(InsecureSignature.getCPtr(signature), signature), true);
    }

    public boolean Verify(MessageHashVector hashes, PublicKeyVector pubKeys) {
        Preconditions.checkNotNull((Object)hashes);
        Preconditions.checkNotNull((Object)pubKeys);
        Preconditions.checkArgument((hashes.size() == pubKeys.size() ? 1 : 0) != 0, (Object)"hashes and public keys  must be of the same size");
        Preconditions.checkArgument((hashes.size() > 0 ? 1 : 0) != 0, (Object)"hashes and public keys must be at least 1");
        return JNI.InsecureSignature_Verify(this.cPointer, this, MessageHashVector.getCPtr(hashes), PublicKeyVector.getCPtr(pubKeys), pubKeys);
    }

    public boolean Verify(byte[] hash, PublicKey pubKey) {
        Preconditions.checkNotNull((Object)hash);
        Preconditions.checkNotNull((Object)pubKey);
        PublicKeyVector pubKeys = new PublicKeyVector();
        pubKeys.push_back(pubKey);
        MessageHashVector hashes = new MessageHashVector();
        hashes.push_back(hash);
        return this.Verify(hashes, pubKeys);
    }

    public static InsecureSignature Aggregate(InsecureSignatureVector sigs) {
        Preconditions.checkNotNull((Object)sigs);
        Preconditions.checkArgument((sigs.size() > 0 ? 1 : 0) != 0);
        return new InsecureSignature(JNI.InsecureSignature_Aggregate(InsecureSignatureVector.getCPtr(sigs)), true);
    }

    public InsecureSignature DivideBy(InsecureSignatureVector sigs) {
        Preconditions.checkNotNull((Object)sigs);
        Preconditions.checkArgument((sigs.size() > 0 ? 1 : 0) != 0);
        return new InsecureSignature(JNI.InsecureSignature_DivideBy(this.cPointer, this, InsecureSignatureVector.getCPtr(sigs)), true);
    }

    public void Serialize(byte[] buffer) {
        Preconditions.checkNotNull((Object)buffer);
        Preconditions.checkArgument(((long)buffer.length >= SIGNATURE_SIZE ? 1 : 0) != 0);
        JNI.InsecureSignature_Serialize__SWIG_0(this.cPointer, this, buffer);
    }

    public byte[] Serialize() {
        byte[] bytes = new byte[(int)SIGNATURE_SIZE];
        this.Serialize(bytes);
        return bytes;
    }

    public String toString() {
        return "InsecureSignature(" + Utils.HEX.encode(this.Serialize()) + ")";
    }
}

