/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.bls;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.dashj.bls.BLSObject;
import org.dashj.bls.InsecureSignature;
import org.dashj.bls.JNI;
import org.dashj.bls.PrivateKeyVector;
import org.dashj.bls.PublicKey;
import org.dashj.bls.PublicKeyVector;
import org.dashj.bls.Signature;
import org.dashj.bls.Utils;

public class PrivateKey
extends BLSObject {
    public static final long PRIVATE_KEY_SIZE = JNI.PrivateKey_PRIVATE_KEY_SIZE_get();

    protected PrivateKey(long cPtr, boolean cMemoryOwn) {
        super(cPtr, cMemoryOwn);
    }

    protected static long getCPtr(PrivateKey obj) {
        return obj == null ? 0L : obj.cPointer;
    }

    @Override
    public synchronized void delete() {
        JNI.delete_PrivateKey(this.cPointer);
    }

    public static PrivateKey FromSeed(byte[] seed, long seedLen) {
        Preconditions.checkNotNull((Object)seed);
        Preconditions.checkArgument((seedLen <= (long)seed.length ? 1 : 0) != 0);
        return new PrivateKey(JNI.PrivateKey_FromSeed(seed, seedLen), true);
    }

    public static PrivateKey FromBytes(byte[] bytes, boolean modOrder) {
        Preconditions.checkNotNull((Object)bytes);
        Preconditions.checkArgument(((long)bytes.length == PRIVATE_KEY_SIZE ? 1 : 0) != 0, (Object)("bytes size is not " + PRIVATE_KEY_SIZE));
        return new PrivateKey(JNI.PrivateKey_FromBytes__SWIG_0(bytes, modOrder), true);
    }

    public static PrivateKey FromBytes(byte[] bytes) {
        Preconditions.checkNotNull((Object)bytes);
        Preconditions.checkArgument(((long)bytes.length == PRIVATE_KEY_SIZE ? 1 : 0) != 0);
        return new PrivateKey(JNI.PrivateKey_FromBytes__SWIG_1(bytes), true);
    }

    public PrivateKey(PrivateKey k) {
        this(JNI.new_PrivateKey__SWIG_0(PrivateKey.getCPtr(k), k), true);
    }

    public PublicKey GetPublicKey() {
        return new PublicKey(JNI.PrivateKey_GetPublicKey(this.cPointer, this), true);
    }

    public static PrivateKey AggregateInsecure(PrivateKeyVector privateKeys) {
        Preconditions.checkNotNull((Object)privateKeys);
        Preconditions.checkArgument((privateKeys.size() > 0 ? 1 : 0) != 0, (Object)"The number of private keys must be larger than 1");
        return new PrivateKey(JNI.PrivateKey_AggregateInsecure(PrivateKeyVector.getCPtr(privateKeys), privateKeys), true);
    }

    public static PrivateKey Aggregate(PrivateKeyVector privateKeys, PublicKeyVector pubKeys) {
        Preconditions.checkNotNull((Object)privateKeys);
        Preconditions.checkNotNull((Object)pubKeys);
        Preconditions.checkArgument((privateKeys.size() == pubKeys.size() ? 1 : 0) != 0);
        Preconditions.checkArgument((privateKeys.size() > 0 ? 1 : 0) != 0, (Object)"The number of private keys must be larger than 1");
        return new PrivateKey(JNI.PrivateKey_Aggregate(PrivateKeyVector.getCPtr(privateKeys), privateKeys, PublicKeyVector.getCPtr(pubKeys)), true);
    }

    public void Serialize(byte[] buffer) {
        Preconditions.checkNotNull((Object)buffer);
        Preconditions.checkArgument(((long)buffer.length >= PRIVATE_KEY_SIZE ? 1 : 0) != 0);
        JNI.PrivateKey_Serialize__SWIG_0(this.cPointer, this, buffer);
    }

    public byte[] Serialize() {
        byte[] bytes = new byte[(int)PRIVATE_KEY_SIZE];
        this.Serialize(bytes);
        return bytes;
    }

    public String toString() {
        return "PrivateKey(" + Utils.HEX.encode(this.Serialize()) + ")";
    }

    public InsecureSignature SignInsecure(byte[] msg, long len) {
        Preconditions.checkNotNull((Object)msg);
        Preconditions.checkArgument(((long)msg.length == len ? 1 : 0) != 0);
        return new InsecureSignature(JNI.PrivateKey_SignInsecure(this.cPointer, this, msg, len), true);
    }

    public InsecureSignature SignInsecurePrehashed(byte[] hash) {
        Preconditions.checkNotNull((Object)hash);
        return new InsecureSignature(JNI.PrivateKey_SignInsecurePrehashed(this.cPointer, this, hash), true);
    }

    public Signature Sign(byte[] msg, long len) {
        Preconditions.checkNotNull((Object)msg);
        Preconditions.checkArgument(((long)msg.length == len ? 1 : 0) != 0);
        return new Signature(JNI.PrivateKey_Sign(this.cPointer, this, msg, len), true);
    }

    public Signature SignPrehashed(byte[] hash) {
        Preconditions.checkNotNull((Object)hash);
        return new Signature(JNI.PrivateKey_SignPrehashed(this.cPointer, this, hash), true);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PrivateKey)) {
            return false;
        }
        PrivateKey privateKey = (PrivateKey)obj;
        byte[] theseBytes = new byte[(int)PRIVATE_KEY_SIZE];
        this.Serialize(theseBytes);
        byte[] bytes = new byte[(int)PRIVATE_KEY_SIZE];
        privateKey.Serialize(bytes);
        return Arrays.equals(theseBytes, bytes);
    }
}

