/*
 * Decompiled with CFR 0.152.
 */
package org.dashj.bls;

import com.google.common.base.Preconditions;
import java.util.AbstractList;
import java.util.Collection;
import org.dashj.bls.JNI;
import org.dashj.bls.PrivateKey;

public class PrivateKeyVector
extends AbstractList<PrivateKey> {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected PrivateKeyVector(long cPtr, boolean cMemoryOwn) {
        Preconditions.checkArgument((cPtr != 0L ? 1 : 0) != 0);
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(PrivateKeyVector obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                JNI.delete_PrivateKeyVec(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public PrivateKeyVector(Collection<PrivateKey> e) {
        this.reserve(e.size());
        for (PrivateKey value : e) {
            this.push_back(value);
        }
    }

    public PrivateKeyVector() {
        this(JNI.new_PrivateKeyVec__SWIG_0(), true);
    }

    public PrivateKeyVector(PrivateKeyVector o) {
        this(JNI.new_PrivateKeyVec__SWIG_2(PrivateKeyVector.getCPtr(o), o), true);
    }

    public long capacity() {
        return JNI.PrivateKeyVec_capacity(this.swigCPtr, this);
    }

    public void reserve(long n) {
        JNI.PrivateKeyVec_reserve(this.swigCPtr, this, n);
    }

    @Override
    public boolean isEmpty() {
        return JNI.PrivateKeyVec_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        JNI.PrivateKeyVec_clear(this.swigCPtr, this);
    }

    public void push_back(PrivateKey x) {
        Preconditions.checkNotNull((Object)x);
        JNI.PrivateKeyVec_push_back(this.swigCPtr, this, PrivateKey.getCPtr(x), x);
    }

    @Override
    public PrivateKey get(int i) {
        return new PrivateKey(JNI.PrivateKeyVec_get(this.swigCPtr, this, i), false);
    }

    @Override
    public PrivateKey set(int i, PrivateKey VECTOR_VALUE_IN) {
        Preconditions.checkNotNull((Object)VECTOR_VALUE_IN);
        return new PrivateKey(JNI.PrivateKeyVec_set(this.swigCPtr, this, i, PrivateKey.getCPtr(VECTOR_VALUE_IN), VECTOR_VALUE_IN), true);
    }

    @Override
    public int size() {
        return JNI.PrivateKeyVec_size(this.swigCPtr, this);
    }

    @Override
    public void removeRange(int from, int to) {
        JNI.PrivateKeyVec_removeRange(this.swigCPtr, this, from, to);
    }
}

